package com.digiwin.mobile.mobileuibot.core.component.qrcode;

import com.digiwin.mobile.mobileuibot.common.crypto.aes.AESUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.util.HashMap;

/**
 * 二维码内容存储的信息
 *
 * @author zhangjj
 * @date 2022/9/14 15:51
 */
@Data
@Component
public class QrCodeContentMsg extends HashMap<String, String> implements Serializable {

    private static final long serialVersionUID = 7122712833233796728L;

    //智联云-在途宝扫码接单业务
    public static final String BIZ_TYPE_ZHILINK_ITM = "ZHILINK_ITM";
    //智联云-在途宝扫码司机接单业务
    public static final String BIZ_TYPE_DRIVER_CODE = "DRIVER_CODE";
    //智联云-在途宝扫码货物码
    public static final String BIZ_TYPE_BAR_CODE = "BAR_CODE";
    //智互联-在途宝扫描ASN
    public static final String BIZ_TYPE_ASN_CODE = "ASN_CODE";
    //智互联-在途宝扫描运单号
    public static final String BIZ_TYPE_TRANSPORT_RECEIVE = "TRANSPORT_RECEIVE";

    private static String aesKey;
    /**
     * 业务id，必填，会根据此值判断扫码后的动作
     */
    private String bizType;

    /**
     * 时间戳
     */
    private String timestamp = String.valueOf(System.currentTimeMillis());

    public QrCodeContentMsg(String bizType) {
        bizType = encrypt(bizType);
        this.bizType = bizType;
    }

    /**
     * 重写put方法，给value值加密
     *
     * @param key   key with which the specified value is to be associated
     * @param value value to be associated with the specified key
     * @return
     */
    @Override
    public String put(String key, String value) {
        value = encrypt(value);
        return super.put(key, value);
    }

    private QrCodeContentMsg() {
    }

    @Autowired
    public void init(SysEnvConfig sysEnvConfig) {
        QrCodeContentMsg.aesKey = sysEnvConfig.getAesKey();
    }

    private String encrypt(String content) {
        try {
            content = AESUtil.encrypt(QrCodeContentMsg.aesKey, content);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return content;
    }

}
