package com.digiwin.mobile.mobileuibot.core.component.search;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：搜索组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: Search.java
 * @Author: wangjwc
 * @Date: created at 2025/3/27 10:13
 */
@Data
public class Search extends BaseMobileComponent {
    private static final long serialVersionUID = 4786570134301755474L;
    public static final String COMPONENT_TYPE = "SEARCH";

    List<BottomButtonDigiwinAthena> customButtonList;

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    /**
     * 初始化设置
     * 1、多语言设置
     * 2、按钮请求地址设置
     *
     * @param locale
     */
    public void initSetting(String locale) {
        if (this.customButtonList == null || this.customButtonList.isEmpty()) {
            return;
        }
        for (BottomButtonDigiwinAthena buttonDigiwinAthena : customButtonList) {
            if (buttonDigiwinAthena.getName() != null) {
                buttonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, buttonDigiwinAthena.getName()));
            }
            this.setRequestUrl(buttonDigiwinAthena);
            List<BottomButtonDigiwinAthena> children = buttonDigiwinAthena.getChildren();
            if (children != null && children.size() > 0) {
                for (BottomButtonDigiwinAthena button : children) {
                    if (button.getName() != null) {
                        button.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, button.getName()));
                    }
                    this.setRequestUrl(button);
                }
            }
        }
    }

    private void setRequestUrl(BottomButtonDigiwinAthena button) {
        Action action = button.getAction();
        if (action == null || action.getRequestUrl() == null || action.getRequestUrl().length() == 0) {
            return;
        }
        action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
    }

    /**
     * 提示文字
     */
    private String placeholder;
    /**
     * 清除按钮- true/false （默认值为true）
     */
    private Boolean clear = true;
    /**
     * 搜索类型，1、当前页搜索，2、跳转搜索页
     * @see SearchTypeEnum
     */
    private Integer searchType = SearchTypeEnum.CURRENT_PAGE_SEARCH.getValue();
    /**
     * 设计器：跳转搜索页按钮--设计态设计的结构
     * type=2时，存在
     */
    private UiBotAction jumpButton;
    /**
     * 运行态：跳转搜索页按钮--运行态运行的结构
     * type=2时，存在
     */
    private Action<Map<String, Object>> action;

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        if (SearchTypeEnum.JUMP_PAGE_SEARCH.getValue().equals(this.searchType) && this.jumpButton != null) {
            // 跳转搜索页按钮
            this.action = this.getAction(this.jumpButton, cmptContext, mobilePath, schema, executeContext, mobilePageRawData);
        }

        // clear
        this.jumpButton = null;
    }

    public Action<Map<String, Object>> getAction(UiBotAction jumpButton, ComponentContext cmptContext, String mobilePath, String schema, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        Button<UiBotAction> button = new Button<>();
        button.setSubmitAction(jumpButton);
        button.handleComponentParam(cmptContext, mobilePath, schema, new HashMap<>(), executeContext, mobilePageRawData);
        return button.getAction();
    }
}
