package com.digiwin.mobile.mobileuibot.core.component.search;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Field;

import java.io.Serializable;

/**
 * 搜索的分类
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SearchCategory implements Serializable {
    private static final long serialVersionUID = -2479767272220152167L;

    @Field(value = "id")
    private String id;
    private String name;

    public static SearchCategory build(String id, String name) {
        SearchCategory searchCategory = new SearchCategory();
        searchCategory.setId(id);
        searchCategory.setName(name);
        return searchCategory;
    }
}
