package com.digiwin.mobile.mobileuibot.core.component.search;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 跳转配置  主要包含跳转路径、跳转参数
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SkipConfig implements Serializable {
    private static final long serialVersionUID = -5697537207435841079L;

    /**
     * 跳转的路径
     */
    private String skipUrl;
    /**
     * 跳转的路径
     */
    private String jumpUrl;
    /**
     * 跳转路径需要携带的参数
     */
    private Map<String, Object> params = new HashMap<>();
    /**
     * 查询的类型
     */
    private String taskCode;
    /**
     * 查询的入参
     */
    private String queryName;
    /**
     * 1为get请求，2为post请求
     */
    private Integer requestType;
    /**
     * pageId
     */
    private String pageId;
    /**
     * 数据id，用于区分不同页面的左滑页面
     */
    private String dataId;
}
