package com.digiwin.mobile.mobileuibot.core.component.search;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 模糊搜索返回项组件
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SmartFuzzySearch extends BaseMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "SMART_FUZZY_SEARCH";
    private static final long serialVersionUID = 830529536985517817L;

    /**
     * 显示的文字
     */
    private String text;
    /**
     * 搜索的icon（iconfont库中的icon编号）
     */
    private Integer searchIconData;
    /**
     * 确认的icon
     */
    private Integer enterIconData;
    /**
     * 搜索类型
     * @see SmartSearchTypeEnum
     */
    private Integer searchType;

    @Override
    public String returnComponentType() {
        return SmartFuzzySearch.COMPONENT_TYPE;
    }
}
