package com.digiwin.mobile.mobileuibot.core.component.search;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 精准搜索返回项组件
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SmartPreciseSearch extends BaseMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "SMART_PRECISE_SEARCH";
    private static final long serialVersionUID = 3623308081824002418L;


    /**
     * 前端页面布局 1代表左图右文(默认)；2代表右图左文；3.上图下文；4.上文下图；5.纯图片；6.纯内容
     *
     * @see SmartPreciseSearchStyleTypeEnum
     */
    private Integer styleType;
    private List<SmartPreciseSearchField> fields;

    @JsonProperty("pic")
    @JSONField(name = "pic")
    private List<Pic> pics;
    private Action action;

    // 用于给rawData填入值 start
    private String dataKey;
    private Object queryInfo;
    private String tmActivityId;
    // 用于给rawData填入值 end

    @Override
    public String returnComponentType() {
        return SmartPreciseSearch.COMPONENT_TYPE;
    }
}
