package com.digiwin.mobile.mobileuibot.core.component.search;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.StateTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 精准搜索返回结果项中的字段数据
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SmartPreciseSearchField implements Serializable {
    private static final long serialVersionUID = 4509575330500057675L;

    /**
     * PCuibot字段的schema
     */
    private String fieldId;
    /**
     * PCuibot字段对应的标题
     */
    private String fieldTitle;
    /**
     * PCuibot标题对应的值
     */
    private String fieldValue;
    /**
     * 电话图标
     */
    private Integer phoneIcon;
    /**
     * 1:独占一行，2：和上一个字段并列一行
     */
    private Integer fieldLayoutType;
    /**
     * 修饰 fieldValue 样式
     * 0：一般，灰色；1：正常，蓝色；2：异常，红色
     *
     * @see StateTypeEnum
     */
    private Integer fieldType = StateTypeEnum.GENERAL.getValue();
    /**
     *
     */
    private Integer level;
    /**
     * 是否支持字段跳转
     */
    private Boolean skip;
    /**
     * 字段跳转的相关配置
     */
    private SkipConfig skipConfig;

    public static SmartPreciseSearchField create(String fieldValue, Integer fieldLayoutType) {
        SmartPreciseSearchField searchField = new SmartPreciseSearchField();
        searchField.setFieldId(UUIDUtil.getUuid());
        searchField.setFieldValue(fieldValue);
        searchField.setFieldLayoutType(fieldLayoutType);
        return searchField;
    }

    public static SmartPreciseSearchField create(String fieldValue, Integer fieldLayoutType, Integer phoneIcon) {
        SmartPreciseSearchField searchField = new SmartPreciseSearchField();
        searchField.setFieldId(UUIDUtil.getUuid());
        searchField.setFieldValue(fieldValue);
        searchField.setFieldLayoutType(fieldLayoutType);
        searchField.setPhoneIcon(phoneIcon);
        return searchField;
    }

    public static SmartPreciseSearchField create(String fieldId, String fieldValue, Boolean skip, Integer fieldLayoutType) {
        SmartPreciseSearchField field = new SmartPreciseSearchField();
        field.setFieldId(fieldId);
        field.setFieldValue(fieldValue);
        field.setSkip(skip);
        field.setFieldLayoutType(fieldLayoutType);
        return field;
    }
}
