package com.digiwin.mobile.mobileuibot.core.component.search;

import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * NLP的智能搜索组件
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SmartSearch extends BaseInputMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "SMART_SEARCH";

    /**
     * 搜索类型
     * @see SmartSearchTypeEnum
     */
    private Integer searchType;
    /**
     * 扫描功能是否显示
     */
    private Boolean scanShow;
    /**
     * 回填方式
     * @see SmartSearchBackFillTypeEnum
     */
    private Integer backFillType;
    /**
     * 搜索统计参数
     */
    private Statistics statistics;
    /**
     * 请求后端API
     */
    private String requestUrl;

    public static SmartSearch create(String locale, UiBotTableColumn column, List<UiBotRule> columnRuleList,
                                  Map<String, Object> bizData, List<Rule> mobileRuleList){
        return new SmartSearch();
    }

    @Override
    public String returnComponentType() {
        return SmartSearch.COMPONENT_TYPE;
    }

}
