package com.digiwin.mobile.mobileuibot.core.component.search;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseInputMobileComponent;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：统一搜索组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UniSearch
 * @Author: Zaregoto
 * @Date: 2022/1/24 0:46
 */
public class UniSearch extends BaseInputMobileComponent {
    private static final long serialVersionUID = 3280864057420378050L;
    public static final String COMPONENT_TYPE = "UNI_SEARCH";

    @Override
    public String returnComponentType() {
        return UniSearch.COMPONENT_TYPE;
    }

    /**
     * 搜索样式类型
     *
     * @see UniSearchTypeEnum
     */
    private Integer type;

    /**
     * 不可用时Toast提示信息
     */
    private String disableToastMsg;

    private List<SearchCategory> searchCategories;

    public UniSearch() {
    }


    public UniSearch(Integer type, List<SearchCategory> searchCategory) {
        this.type = type;
        if (searchCategory == null) {
            this.searchCategories = new ArrayList<>();
        } else {
            this.searchCategories = searchCategory;
        }
    }

    @Override
    public void initSetting(String locale) {
        this.setPlaceholder(LocaleUtil.getMobileTextByDatabaseKey(locale, this.getPlaceholder()));
        List<SearchCategory> searchCategories = this.searchCategories;
        if (searchCategories != null && searchCategories.size() > 0) {
            for (SearchCategory searchCategory : searchCategories) {
                searchCategory.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, searchCategory.getName()));
            }
        }
        if (StringUtils.hasLength(disableToastMsg)) {
            this.setDisableToastMsg(LocaleUtil.getMobileTextByDatabaseKey(locale, disableToastMsg));
        }
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public List<SearchCategory> getSearchCategories() {
        return searchCategories;
    }

    public void setSearchCategories(List<SearchCategory> searchCategories) {
        this.searchCategories = searchCategories;
    }

    public String getDisableToastMsg() {
        return disableToastMsg;
    }

    public void setDisableToastMsg(String disableToastMsg) {
        this.disableToastMsg = disableToastMsg;
    }
}
