package com.digiwin.mobile.mobileuibot.core.component.search;

import java.util.Objects;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UniSearchTypeEnum
 * @Author: Zaregoto
 * @Date: 2022/1/24 0:48
 */
public enum UniSearchTypeEnum {
    /**
     * 搜索框右侧含相机图标
     */
    WITH_CAMERA_ACTION(1),

    /**
     * 简洁搜索框，框内无任何图标
     */
    WITH_NOTHING_BUT_EASY(2),

    /**
     * 嵌入首页导航栏的样式
     */
    EMBEDDED_IN_INDEX_NAVBAR(3),

    ;

    private final Integer value;

    UniSearchTypeEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static UniSearchTypeEnum getEnumByValue(Integer value) {
        for (UniSearchTypeEnum testedEnum : UniSearchTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
