package com.digiwin.mobile.mobileuibot.core.component.tab.customtab;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerTabAlignEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;
import org.apache.commons.collections4.MapUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * <p>功能描述：单TAB页签组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomTabs
 * @Author: Zaregoto
 * @Date: 2021/7/5 23:38
 */
@Data
public class CustomTab extends BaseCustomTab<CustomTabContentContainer> {
    private static final long serialVersionUID = -1198145227690928415L;
    public static final String COMPONENT_TYPE = "CUSTOM_TAB";

    @Override
    public String returnComponentType() {
        return CustomTab.COMPONENT_TYPE;
    }

    @JsonDeserialize(contentUsing = CustomTabContentContainerJsonDeserializer.class)
    private List<CustomTabContentContainer> content = new ArrayList<>();

    /**
     * tab 标记
     */
    private String id;
    /**
     * 对齐方式
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerTabAlignEnum
     */
    private Integer alignmentType = CustomTabControllerTabAlignEnum.CENTER.getValue();
    /**
     * Tab页签 的刷新模式
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabRefreshTypeEnum
     */
    private Integer refreshType = CustomTabRefreshTypeEnum.NO_REFRESH.getMode();
    /**
     * 刷新配置 refreshType!=0 有效
     */
    private CustomTabRefreshConfig refreshConfig;

    /**
     * tab内容的滚动模式。默认在tab页签进行滚动
     */
    private Integer scrollMode = CustomTabScrollModeEnum.TAB_SCROLL.getMode();
    /**
     * 1为旧样式，2位新样式
     */
    private Integer style = 1;
    /**
     * 是否是否进去就展示
     */
    private Boolean isSelected = false;


    //展示哪一个tab页签
    private Integer defaultSelected = 0;

    /**
     * 背景颜色
     *
     * @see BackgroundColorEnum
     */
    private String backgroundColor;

    /**
     * 未处理数量（红色圆圈显示数量）
     */
    private Integer unHandleCount;

    public CustomTab() {
    }

    public CustomTab(String name) {
        super(name);
    }

    public CustomTab(String name, String desc) {
        super(name, desc);
    }

    public void addCustomTabContentContainer(CustomTabContentContainer container) {
        if (null != container) {
            this.content.add(container);
        }
    }

    public void updateRefreshConfigParam(String iamUserToken, String locale, String clientId, String tenantId,
                                         String pageId, Map<String, Object> rawData) {
        if (refreshType != null && !refreshType.equals(CustomTabScrollModeEnum.TAB_SCROLL.getMode())) {
            // 设置请求地址的hostname为当前工程的外网访问地址
            String configuredUrl = refreshConfig.getRequestUrl();
            String newUrl = AppContext.getBaseUrl() + configuredUrl
                    + "?clientId=" + clientId
                    + "&tenantId=" + tenantId;
            // 设置当前的iamUserToken与locale
            refreshConfig.setIamUserToken(iamUserToken)
                    .setLocale(locale)
                    .setClientId(clientId)
                    .setTenantId(tenantId)
                    .setRequestUrl(newUrl)
                    .setPageId(pageId)
                    .setRawData(rawData);
        }
    }

    public static void fillSupportTab(ApiRequest apiRequest, CustomTab customTab, List<WoOpReportInfo> woOpReportInfoList) {
        LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);

        // 第一层分组条件根据交付设计器来 1：工单单号， 2：项目号，3：计划批号
        DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService = SpringContextHolder.getBean(DigiwinKnowledgeMapsProxyService.class);
        Map<String, Object> variableListSimpleMap = digiwinKnowledgeMapsProxyService.getVariableListSimple(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), Collections.singletonList("taskNameField"));

        String taskNameField = Optional.ofNullable(variableListSimpleMap).map(e-> MapUtils.getString(e, "taskNameField")).orElse("");
        Map<String, Map<String, List<WoOpReportInfo>>> woOpReportInfoListByWoNoAndOpNo = woOpReportInfoList.stream()
                .collect(Collectors.groupingBy(e -> {
                    if ("2".equals(taskNameField)) {
                        return e.getProjectNo();
                    } else if ("3".equals(taskNameField)) {
                        return e.getPlanLotNo();
                    }
                    return e.getWoNo();
                }, LinkedHashMap::new, Collectors.groupingBy(WoOpReportInfo::getOpNo, LinkedHashMap:: new, Collectors.toList())));
        List<Retractable> retractableList = Retractable.buildRetractable(apiRequest, localeService, woOpReportInfoListByWoNoAndOpNo, taskNameField, null);

        List<CustomTabContentContainer> customTabContentContainerList = retractableList.stream().map(retractable -> {
            CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
            customTabContentContainer.setContentCmptType(Retractable.COMPONENT_TYPE);
            customTabContentContainer.setData(retractable);
            return customTabContentContainer;
        }).collect(Collectors.toList());
        customTab.setContent(customTabContentContainerList);
        customTab.setName(localeService.getLanguageValue(apiRequest.getLocale(), customTab.getName())
                + "(" + woOpReportInfoList.size() + ")");
    }
}
