package com.digiwin.mobile.mobileuibot.core.component.tab.customtab;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListCommonFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListFilterSwitch;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListGroupFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListSeniorFilter;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardListSort;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardDetailPage;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：TAB页签内容容器，将内容所属组件和数据包含在一起</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomTabContentContainer
 * @Author: Zaregoto
 * @Date: 2021/7/5 23:47
 */
@Data
public class CustomTabContentContainer<T> extends BaseMobileComponent {
    private static final long serialVersionUID = -1808975383171790626L;
    public static final String COMPONENT_TYPE = "CUSTOM_TAB_CONTENT_CONTAINER";

    /**
     * 容器内使用的其他组件的TYPE，非当前组件的TYPE
     */
    // FIXME 后续要调整JSON处理的工具类，统一一种注解
    @JsonProperty("componentType")
    @JSONField(name = "componentType")
    private String contentCmptType;
    private T data;
    /**
     * 是否主组件。主组件会将其他组件合并进来，以支持组件内的滚动逻辑。可选值有两个，true：是，false：不是，默认值。
     */
    private Boolean major;
    /**
     * 组件位置。参考：com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentPositionEnum
     */
    private Integer position;
    private TabItemCardDetailPage detailPage;
    private List<CardListFilter> filterList = new ArrayList<>(16);
    private List<String> filterIdList = new ArrayList<>(16);
    private CardListSeniorFilter seniorFilter;
    private CardListCommonFilter commonFilter;
    private Boolean isUseSeniorFilter;
    private List<String> groupFilterIdList = new ArrayList<>(16);
    private List<CardListGroupFilter> groupFilterList = new ArrayList<>(16);
    private CardListSort sortFilter;
    private CardListFilterSwitch showEocSwitch;
    private CardListFilterSwitch showHandledCardSwitch;
    private List<String> searchIdList = new ArrayList<>(16);
    private String searchUrl;
    private String queryParam;

    public CustomTabContentContainer() {
    }

    public String getContentCmptType() {
        return contentCmptType;
    }

    public void setContentCmptType(String contentCmptType) {
        this.contentCmptType = contentCmptType;
    }


    @Override
    public String returnComponentType() {
        return CustomTabContentContainer.COMPONENT_TYPE;
    }

    /**
     * 创建一个空的TAB页签内容容器
     *
     * @param locale
     * @return
     */
    public static CustomTabContentContainer emptyContainer(String locale) {
        CustomTabContentContainer container = new CustomTabContentContainer();
        container.setContentCmptType(CustomGroup.COMPONENT_TYPE);
        container.setData(CustomGroup.createEmptyGroup(locale, ""));
        return container;
    }

    /**
     * 创建一个空的TAB页签内容容器不包含CustomGroup
     *
     * @param locale
     * @return
     */
    public static CustomTabContentContainer emptyContainerUnContainCustomGroup(String locale) {
        CustomTabContentContainer container = new CustomTabContentContainer();
        container.setContentCmptType(Empty.COMPONENT_TYPE);
        container.setData(Empty.create(LocaleUtil.getMobileTextByKey(locale, "暂无数据"), true));
        return container;
    }
}
