package com.digiwin.mobile.mobileuibot.core.component.tab.customtab;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.CustomList;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;

import java.io.IOException;
import java.util.List;
import java.util.Optional;

/**
 * <p>功能描述：针对<code>CustomTabContentContainer</code>类的自定义JSON反序列化类 </p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomTabContentContainerJsonDeserializer
 * @Author: wangjwc
 * @Date: 2023/6/29 17:56
 */
@Slf4j
public class CustomTabContentContainerJsonDeserializer extends JsonDeserializer<CustomTabContentContainer> {

    @Override
    public CustomTabContentContainer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext)
            throws IOException {
        log.debug("CustomTabContentContainerJsonDeserializer run to prehandle data to component instance...");
        JsonNode node = jsonParser.getCodec().readTree(jsonParser);
        CustomTabContentContainer customTabContentContainer =
                JsonUtil.jsonStringToObject(node.toString(), CustomTabContentContainer.class);

        if (BooleanUtils.isTrue(AppRequestContext.getContextEntity().getIsUpgrade())) {
            String componentType = Optional.ofNullable(node.get("componentType")).map(JsonNode::asText).orElse("");
            if (componentType.startsWith("DW_")) {
                componentType = componentType.substring(3);
            }
            // 升级场景下必有前缀
            customTabContentContainer.setContentCmptType("DW_" + componentType);

            Class<? extends MobileComponent> cmptClazz = MobileRenderDataUtil.customizeListComponentsMap.get(componentType);
            if (null != cmptClazz) {
                // 定制的列表组件Map
                MobileComponent mobileComponent = JsonUtil.objectToJavaObject(node.get("data"), cmptClazz);
                CustomList<List> customList = new CustomList<>();
                customList.setContent((List) mobileComponent);
                customList.setComponentType(componentType);
                // 重新赋值
                customTabContentContainer.setData(customList);
            }
        } else {
            // 如果反序列化前有前缀则继续加上前缀，场景如：设计器设计DSL就是带有前缀
        }
        return customTabContentContainer;
    }

}
