package com.digiwin.mobile.mobileuibot.core.component.tab.customtab;

/**
 * 功能: 自定义Tab页签组件的刷新类型枚举
 *
 * @author: wjw
 * @date: created at 2023/3/9
 */
public enum CustomTabRefreshTypeEnum {
    /**
     * tabs 组件整体数据刷新，重新渲染
     */
    ALL_REFRESH(2),
    /**
     * tab 单个页签数据刷新，重新渲染
     */
    SINGLE_REFRESH(1),
    /**
     * tab 页签数据不刷新，重新渲染
     */
    NO_REFRESH(0);

    private Integer mode;

    CustomTabRefreshTypeEnum(Integer mode) {
        this.mode = mode;
    }

    public Integer getMode() {
        return mode;
    }
}
