package com.digiwin.mobile.mobileuibot.core.component.tab.customtab;

/**
 * <p>功能描述：自定义Tab页签组件的滚动模式枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomTabScrollModeEnum
 * @Author: Zaregoto
 * @Date: 2021/8/9 20:09
 */
public enum CustomTabScrollModeEnum {
    /**
     * 由tab组件支持滚动，若内容组件也设置滚动，app的显示会有异常，反之则不会；
     */
    TAB_SCROLL(1),

    /**
     * tab组件不滚动，由内容组件进行滚动
     */
    CONTENT_SCROLL(2),
    /**
     * tab全部不滚动
     */
    NO_SCROLL(3),
    ;

    private Integer mode;

    CustomTabScrollModeEnum(Integer mode) {
        this.mode = mode;
    }

    public Integer getMode() {
        return mode;
    }
}
