package com.digiwin.mobile.mobileuibot.core.component.tab.customtab;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.graphicdisplay.GraphicDisplay;
import com.digiwin.mobile.mobileuibot.core.component.input.addersubstracter.AdderSubstracter;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleItemLabel;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListChoiceEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListDataList;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionListStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardDetailPage;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbCargoUnloading;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbDeliveryLoadingCount;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.ZtbTransportReceiptStatusCount;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import org.apache.commons.collections4.MapUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：自定义多TAB页签组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomTabs
 * @Author: Zaregoto
 * @Date: 2021/8/5 17:32
 */
public class CustomTabs extends ArrayList<CustomTab> implements MobileComponent, Serializable {
    private static final long serialVersionUID = 2951478276712261865L;
    public static final String COMPONENT_TYPE = "CUSTOM_TABS";

    /**
     * 判断是否置灰底部按钮（仅用于APC的工时支援）
     */
    private Boolean grayButton;

    /**
     * 标题schema
     */
    public static final String titleSchema = "op_name";
    /**
     * 未完成的schemas
     */
    public static final List<ColumnTag> unCompleteSchemas = new ArrayList<>(55);

    static {
        unCompleteSchemas.add(new ColumnTag("abnormal_doc_no", "异常单号"));
        unCompleteSchemas.add(new ColumnTag("abnormal_reason_name", "异常原因"));
        unCompleteSchemas.add(new ColumnTag("abnormal_reason_description", "异常原因描述"));
        unCompleteSchemas.add(new ColumnTag("reporter_name", "报工人员"));
        unCompleteSchemas.add(new ColumnTag("report_date", "报工时间"));
        unCompleteSchemas.add(new ColumnTag("abnormal_reason_attachment", "附加档案"));
    }

    /**
     * 已完成的schemas
     */
    public static final List<ColumnTag> completeSchemas = new ArrayList<>(7);

    static {
        completeSchemas.add(new ColumnTag("abnormal_doc_no", Field.COMPONENT_TYPE, "异常单号"));
        completeSchemas.add(new ColumnTag("abnormal_reason_name", Field.COMPONENT_TYPE, "异常原因"));
        completeSchemas.add(new ColumnTag("abnormal_reason_description", Field.COMPONENT_TYPE, "异常原因描述"));
        completeSchemas.add(new ColumnTag("reporter_name", Field.COMPONENT_TYPE, "处理人员"));
        completeSchemas.add(new ColumnTag("process_datetime", Field.COMPONENT_TYPE, "处理时间"));
        completeSchemas.add(new ColumnTag("process_description", Field.COMPONENT_TYPE, "處理描述"));
        completeSchemas.add(new ColumnTag("abnormal_handle_attachment", Attachment.COMPONENT_TYPE, "附加档案"));
    }

    @Override
    public String returnComponentType() {
        return CustomTabs.COMPONENT_TYPE;
    }

    public CustomTabs(int initialCapacity) {
        super(initialCapacity);
    }

    public CustomTabs() {
    }

    public CustomTabs(Collection<? extends CustomTab> c) {
        super(c);
    }

    public static CustomTabs createEmpty() {
        return new CustomTabs();
    }

    public Boolean getGrayButton() {
        return grayButton;
    }

    public void setGrayButton(Boolean grayButton) {
        this.grayButton = grayButton;
    }

    public CustomTabs detailMessage(CustomTabs customTabs, ZtbDeliveryLoadingCount counts,
                                    List<ZtbCargoUnloading> ztbCargoUnloadings,
                                    List<ZTBDriverVehicle> ztbDriverVehicles,
                                    LocaleService localeService, String locale, Boolean isSubmit,
                                    DigiwinDmcProxyService digiwinDmcProxyService) {
        for (int i = 0; i < customTabs.size(); i++) {
            CustomTab customTab = customTabs.get(i);
            List<CustomTabContentContainer> content;
            customTab.setAlignmentType(1);
            customTab.setStyle(2);
            if (i == 0) {
                customTab.setName(localeService.getLanguageValue(locale, customTab.getName()) + " (" + counts.getUnloadItemCount() + ")");
                content = new ArrayList<>(ztbCargoUnloadings.size());
                for (ZtbCargoUnloading cargoUnloading : ztbCargoUnloadings) {
                    CustomTabContentContainer container = new CustomTabContentContainer();
                    container.setContentCmptType(Card.COMPONENT_TYPE);
                    Card card = new Card();
                    StringBuffer title = new StringBuffer();
                    if (StringUtils.hasLength(cargoUnloading.getItemNo())) {
                        title.append(cargoUnloading.getItemNo()).append("-");
                    }
                    if (StringUtils.hasLength(cargoUnloading.getItemName())) {
                        title.append(cargoUnloading.getItemName());
                    } else {
                        title.append("-");
                    }
                    card.setTitle(title.toString());
                    List<CardContent> cardContents = new ArrayList<>(1);
                    CardContent cardContent = new CardContent();
                    cardContent.setLabel(localeService.getLanguageValue(locale, "应发数量"));
                    cardContent.setValue(cargoUnloading.getUnLoadingQty() + " " + cargoUnloading.getUnitName());
                    cardContent.setValueStyleType(1);
                    cardContents.add(cardContent);
                    card.setContent(cardContents);
                    card.setDataId(cargoUnloading.getItemNo());
                    card.setDetail(JsonUtil.objectToJavaObject(cargoUnloading, Map.class));
                    container.setData(card);
                    content.add(container);
                }
            } else {
                if (isSubmit) {
                    customTab.setIsSelected(true);
                }
                customTab.setName(localeService.getLanguageValue(locale, customTab.getName()) + " (" + counts.getLoadedItemCount() + ")");
                content = new ArrayList<>(ztbDriverVehicles.size());
                for (ZTBDriverVehicle driverVehicle : ztbDriverVehicles) {
                    CustomTabContentContainer container = new CustomTabContentContainer();
                    container.setContentCmptType(GraphicDisplay.COMPONENT_TYPE);
                    container.setData(GraphicDisplay.create(driverVehicle, 1, digiwinDmcProxyService));
                    TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
                    detailPage.setDataId(driverVehicle.getTransportNo());
                    detailPage.setRawData(JsonUtil.objectToJavaObject(driverVehicle, Map.class));
                    detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ZTB_DELIVERY_LOADED_ITEM.toString());
                    container.setDetailPage(detailPage);
                    content.add(container);
                }
            }
            customTab.setContent(content);
        }
        return customTabs;
    }

    public CustomTabs detailMessage(CustomTabs customTabs, Map<String,
            List<ZtbCargoUnloading>> cargoInfoMaps, List<ZtbTransportReceiptStatusCount> counts,
                                    LocaleService localeService, String locale, Boolean hasReject) {
        for (int i = 0; i < customTabs.size(); i++) {
            CustomTab tab = customTabs.get(i);
            ZtbTransportReceiptStatusCount ztbTransportReceiptStatusCount = counts.get(i);
            List<ZtbCargoUnloading> ztbCargoUnloadings = cargoInfoMaps.get(ztbTransportReceiptStatusCount.getReceiptStatus());
            tab.setName(localeService.getLanguageValue(locale,
                    ztbTransportReceiptStatusCount.getReceiptStatusName())
                    + "(" + counts.get(i).getReceiptStatusCount() + ")");
            tab.setAlignmentType(1);
            tab.setStyle(2);
            List<CustomTabContentContainer> content = new ArrayList<>(ztbCargoUnloadings.size());
            //待收货，采用多功能列表
            if (i == 0) {
                CustomTabContentContainer container = new CustomTabContentContainer();
                if (CollectionUtils.isEmpty(ztbCargoUnloadings)) {
                    container.setContentCmptType(Empty.COMPONENT_TYPE);
                    container.setData(Empty.create(localeService.getLanguageValue(locale, "暂无数据")));
                } else {
                    container.setContentCmptType(MultiFunctionList.COMPONENT_TYPE);
                    MultiFunctionList multiFunctionList = new MultiFunctionList();
                    multiFunctionList.setChoice(MultiFunctionListChoiceEnum.MULTIPLE_CHOICE.toString());
                    multiFunctionList.setPageable(false);
                    multiFunctionList.setRequired(true);
                    multiFunctionList.setStyleType(MultiFunctionListStyleTypeEnum.CARD.toString());
                    List<MultiFunctionListDataList> dataList = new ArrayList<>(ztbCargoUnloadings.size());
                    for (ZtbCargoUnloading cargoUnloading : ztbCargoUnloadings) {
                        MultiFunctionListDataList data = new MultiFunctionListDataList();
                        data.setAdderSubstracter(AdderSubstracter.create(locale, localeService,
                                cargoUnloading.getUnReceiptQty(), cargoUnloading.getUnReceiptQty(),
                                1.0, false, false));
                        List<Field> fields = new ArrayList<>(2);
                        //构造规格
                        fields.add(Field.createFieldOfOtherScene(localeService.getLanguageValue(locale, "规格"), cargoUnloading.getItemSpec()));
                        //部门
                        fields.add(Field.createFieldOfOtherScene(localeService.getLanguageValue(locale, "待收货数量"), cargoUnloading.getUnReceiptQty() + " " + cargoUnloading.getUnitName()));
                        data.setTitle(cargoUnloading.getItemNo() + "-" + cargoUnloading.getItemName());
                        data.setDataId(cargoUnloading.getItemNo());
                        data.setDetail(cargoUnloading);
                        data.setContent(fields);
                        dataList.add(data);
                    }
                    multiFunctionList.setDataList(dataList);
                    container.setData(multiFunctionList);
                }
                content.add(container);
                //其他，采用card_list
            } else {
                if (CollectionUtils.isEmpty(ztbCargoUnloadings)) {
                    CustomTabContentContainer container = new CustomTabContentContainer();
                    container.setContentCmptType(Empty.COMPONENT_TYPE);
                    container.setData(Empty.create(localeService.getLanguageValue(locale, "暂无数据")));
                    content.add(container);
                } else {
                    for (ZtbCargoUnloading cargoUnloading : ztbCargoUnloadings) {
                        CustomTabContentContainer container = new CustomTabContentContainer();
                        container.setContentCmptType(Card.COMPONENT_TYPE);
                        Card card = new Card();
                        StringBuffer title = new StringBuffer();
                        if (StringUtils.hasLength(cargoUnloading.getItemNo())) {
                            title.append(cargoUnloading.getItemNo()).append("-");
                        }
                        if (StringUtils.hasLength(cargoUnloading.getItemName())) {
                            title.append(cargoUnloading.getItemName());
                        } else {
                            title.append("-");
                        }
                        card.setTitle(title.toString());
                        String name;
                        String value;
                        if (i == 2) {
                            name = "拒收数量";
                            value = cargoUnloading.getRejectQty();
                            card.setSubTitle(cargoUnloading.getRejectTypeName());
                            tab.setIsSelected(hasReject);
                        } else if (i == 1) {
                            name = "已收货数量";
                            value = cargoUnloading.getReceiptQty();
                        } else {
                            name = "数量";
                            value = "0";
                        }
                        List<CardContent> cardContents = new ArrayList<>(2);
                        cardContents.add(new CardContent(localeService.getLanguageValue(locale, "规格"), cargoUnloading.getItemSpec(), 1));
                        cardContents.add(new CardContent(localeService.getLanguageValue(locale, name), value + " " + cargoUnloading.getUnitName(), 1));
                        card.setContent(cardContents);
                        card.setDataId(cargoUnloading.getItemNo());
                        card.setDetail(JsonUtil.objectToJavaObject(cargoUnloading, Map.class));
                        container.setData(card);
                        content.add(container);
                    }
                }
            }
            tab.setContent(content);
        }
        return customTabs;
    }

    public CustomTabs detailMessage(CustomTabs customTabs, List<ZtbTransportReceiptStatusCount> counts,
                                    Map<String, Object> cargoInfoMaps, String locale,
                                    LocaleService localeService) {
        for (int i = 0; i < customTabs.size(); i++) {
            CustomTab tab = customTabs.get(i);
            ZtbTransportReceiptStatusCount ztbTransportReceiptStatusCount = counts.get(i + 1);
            List<ZtbCargoUnloading> ztbCargoUnloadings = ModuleUtils.listMapToListObject((List<?>)
                            cargoInfoMaps.get(ztbTransportReceiptStatusCount.getReceiptStatus()),
                    ZtbCargoUnloading.class);
            tab.setName(localeService.getLanguageValue(locale,
                    ztbTransportReceiptStatusCount.getReceiptStatusName())
                    + "(" + counts.get(i + 1).getReceiptStatusCount() + ")");
            tab.setAlignmentType(1);
            tab.setStyle(2);
            List<CustomTabContentContainer> content = new ArrayList<>(ztbCargoUnloadings.size());
            if (CollectionUtils.isEmpty(ztbCargoUnloadings)) {
                CustomTabContentContainer container = new CustomTabContentContainer();
                container.setContentCmptType(Empty.COMPONENT_TYPE);
                container.setData(Empty.create(localeService.getLanguageValue(locale, "暂无数据")));
                content.add(container);
            } else {
                for (ZtbCargoUnloading cargoUnloading : ztbCargoUnloadings) {
                    CustomTabContentContainer container = new CustomTabContentContainer();
                    container.setContentCmptType(Card.COMPONENT_TYPE);
                    Card card = new Card();
                    StringBuffer title = new StringBuffer();
                    if (StringUtils.hasLength(cargoUnloading.getItemNo())) {
                        title.append(cargoUnloading.getItemNo()).append("-");
                    }
                    if (StringUtils.hasLength(cargoUnloading.getItemName())) {
                        title.append(cargoUnloading.getItemName());
                    } else {
                        title.append("-");
                    }
                    card.setTitle(title.toString());
                    card.setSubTitle(cargoUnloading.getRejectType());
                    String name;
                    String value;
                    if (i == 1) {
                        name = "拒收数量";
                        value = cargoUnloading.getRejectQty();
                    } else if (i == 2) {
                        name = "已收货数量";
                        value = cargoUnloading.getReceiptQty();
                    } else {
                        name = "已收货数量";
                        value = cargoUnloading.getReceiptQty();
                    }
                    List<CardContent> cardContents = new ArrayList<>(2);
                    cardContents.add(new CardContent(localeService.getLanguageValue(locale, "规格"), cargoUnloading.getItemSpec(), 1));
                    cardContents.add(new CardContent(localeService.getLanguageValue(locale, name), value + " " + cargoUnloading.getUnitName(), 1));
                    card.setContent(cardContents);
                    card.setDataId(cargoUnloading.getItemNo());
                    card.setDetail(JsonUtil.objectToJavaObject(cargoUnloading, Map.class));
                    container.setData(card);
                    content.add(container);
                }
            }
            tab.setContent(content);
        }
        return customTabs;
    }

    public CustomTabs detailMessage(CustomTabs customTabs, UiBotModel pcUibotModel, UiBotModel completeUibotModel,
                                    String path, String locale,
                                    LocaleService localeService, boolean isTeamTask) {

        List<Map<String, Object>> reportDataList = (List<Map<String, Object>>) MapUtil.getOrDefault(pcUibotModel.getPageData(), path, Collections.emptyList());
        List<Map<String, Object>> datas = reportDataList.stream().filter(item-> Objects.equals("0", MapUtils.getString(item, "process_status"))).collect(Collectors.toList());
        List<Map<String, Object>> completeDatas = reportDataList.stream().filter(item-> Objects.equals("2", MapUtils.getString(item, "process_status"))).collect(Collectors.toList());

        List<UiBotAction> actions = pcUibotModel.getLayout().stream().filter(layout -> "apc_abnormalReport-task-detail-waitting".equals(layout.getType())).findFirst().map(UiBotLayout::getActions).orElse(Collections.emptyList());
        for (int i = 0; i < customTabs.size(); i++) {
            CustomTab tab = customTabs.get(i);
            List<CustomTabContentContainer> containers = new ArrayList<>();
            if (i == 0) {
                tab.setName(localeService.getLanguageValue(locale, tab.getName()) + datas.size());
                if (CollectionUtils.isEmpty(datas)) {
                    containers.add(CustomTabContentContainer.emptyContainerUnContainCustomGroup(locale));
                } else {
                    for (Map<String, Object> data : datas) {
                        CustomTabContentContainer container = new CustomTabContentContainer();
                        container.setContentCmptType(Card.COMPONENT_TYPE);
                        container.setData(Card.create(titleSchema, unCompleteSchemas, data, localeService, locale, actions, datas, pcUibotModel));
                        containers.add(container);
                    }
                }
            } else {
                if (CollectionUtils.isEmpty(completeDatas)) {
                    tab.setName(localeService.getLanguageValue(locale, tab.getName()) + 0);
                    containers.add(CustomTabContentContainer.emptyContainerUnContainCustomGroup(locale));
                } else {
                    tab.setName(localeService.getLanguageValue(locale, tab.getName()) + completeDatas.size());
                    for (Map<String, Object> completeData : completeDatas) {
                        CustomTabContentContainer container = new CustomTabContentContainer();
                        container.setContentCmptType(Card.COMPONENT_TYPE);
                        container.setData(Card.createApcDetail(titleSchema, completeSchemas, completeData, localeService, locale));
                        containers.add(container);
                    }
                }
            }
            tab.setContent(containers);
        }
        return customTabs;
    }

    public CustomTabs detailApcMessage(CustomTabs customTabs, UiBotModel pcUiBotModel,
                                       UiBotModel completeUibotModle, String path, String locale,
                                       LocaleService localeService, String pageId, Boolean isTeamTask) {
        List<Map<String, Object>> datas = (List<Map<String, Object>>) pcUiBotModel.getPageData().get(path);
        List<Map<String, Object>> completeDatas = (List<Map<String, Object>>) completeUibotModle.getPageData().get(path);
        for (int i = 0; i < customTabs.size(); i++) {
            CustomTab tab = customTabs.get(i);
            List<CustomTabContentContainer> containers = new ArrayList<>();
            if (i == 0) {
                List<UiBotAction> actions = pcUiBotModel.getActions();
                if (CollectionUtils.isEmpty(actions)) {
                    UiBotLayout layout = UiBotModel.getCustomUibotLayout(pcUiBotModel.getLayout(), "apc_team_dispatch-task-detail-waitting");
                    if (layout != null) {
                        actions = layout.getActions();
                    }
                }
                tab.setName(localeService.getLanguageValue(locale, tab.getName()) + datas.size());
                if (CollectionUtils.isEmpty(datas)) {
                    containers.add(CustomTabContentContainer.emptyContainerUnContainCustomGroup(locale));
                } else {
                    for (Map<String, Object> data : datas) {
                        CustomTabContentContainer container = new CustomTabContentContainer();
                        container.setContentCmptType(Card.COMPONENT_TYPE);
                        Button button;
                        String subTitle = "";
                        Action subTitleAction = new Action();
                        InputWindowSingleItemLabel label = new InputWindowSingleItemLabel();
                        Integer style = 1;
                        String dataID = UUIDUtil.getUuid();
                        if (PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORK_SHOP_ONLINE.toString().equalsIgnoreCase(pageId)) {
                            button = Button.createApcWorkShopOnlineDeal(locale, localeService, data, actions, dataID, isTeamTask);
                            TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
                            detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_DEAL_DETAIL.toString());
                            detailPage.setRefreshPageId(pageId);
                            detailPage.setDataId(dataID);
                            detailPage.setRawData((Map<String, Object>) button.getAction().getRawData());
                            container.setDetailPage(detailPage);
                        } else {
                            button = Button.createApcTeamDispatch(locale, localeService, dataID);
                            TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
                            detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_TEAM_DISPATCH_DEAL_DETAIL.toString());
                            detailPage.setRefreshPageId(pageId);
                            detailPage.setDataId(dataID);
                            detailPage.setRawData((Map<String, Object>) button.getAction().getRawData());
                            container.setDetailPage(detailPage);
                            //班组派工特有的，如果变更标识为删除，则没有按钮和详情
                            String changeFlag = (String) data.get("change_flag");
                            if (StringUtils.hasLength(changeFlag)) {
                                if ("1".equals(changeFlag)) {
                                    label.setText(localeService.getLanguageValue(locale, "新"));
                                    label.setColor("#4670F7");
                                    label.setBackgroudColor("");
                                } else if ("2".equals(changeFlag)) {
                                    label.setText(localeService.getLanguageValue(locale, "删"));
                                    label.setColor("#4670F7");
                                    label.setBackgroudColor("#ffffff");
                                    style = 2;
                                    ((Map<String, Object>) button.getAction().getRawData()).put("isDelete", true);
                                } else if ("3".equals(changeFlag)) {
                                    label.setText(localeService.getLanguageValue(locale, "改"));
                                    label.setColor("#4670F7");
                                    label.setBackgroudColor("#ffffff");
                                }
                            }
                            String subtitleType = (String) data.get("production_status");
                            if (StringUtils.hasLength(subtitleType)) {
                                if ("1".equals(subtitleType)) {
                                    subTitle = localeService.getLanguageValue(locale, "未开始");
                                } else if ("2".equals(subtitleType)) {
                                    subTitle = localeService.getLanguageValue(locale, "进行中");
                                } else if ("3".equals(subtitleType)) {
                                    subTitle = localeService.getLanguageValue(locale, "已完成");
                                } else if ("4".equals(subtitleType)) {
                                    subTitle = localeService.getLanguageValue(locale, "异常 >");
                                    subTitleAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_APC_PROJECT_SCHEDULE_REPORT_WAIT_DEAL_LIST.toString());
                                    subTitleAction.setJumpPageTitle(localeService.getLanguageValue(locale, "待处理异常清单"));
                                    subTitleAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                                    Map<String, Object> rawData = new HashMap<>(1);
                                    List<Map<String, Object>> titlDatas = new ArrayList<>(1);
                                    Map<String, Object> woOpReportData = new HashMap<>(1);
                                    woOpReportData.put("eoc_company_id", ModuleUtils.emptyString(data.get("eoc_company_id")));
                                    woOpReportData.put("eoc_site_id", ModuleUtils.emptyString(data.get("eoc_site_id")));
                                    woOpReportData.put("eoc_region_id", ModuleUtils.emptyString(data.get("eoc_region_id")));
                                    woOpReportData.put("wo_no", ModuleUtils.emptyString(data.get("wo_no")));
                                    woOpReportData.put("plot_no", ModuleUtils.emptyString(data.get("plot_no")));
                                    woOpReportData.put("op_seq", ModuleUtils.emptyString(data.get("op_seq")));
                                    titlDatas.add(woOpReportData);
                                    rawData.put("wo_op_report_data", titlDatas);
                                    subTitleAction.setRawData(rawData);
                                }
                            }
                        }
                        ModuleUtils.addRefreshPageId(button, pageId);
                        container.setData(Card.createApcWorkShopOnlineCard(tab.getContent(), data,
                                locale, localeService, button, subTitle, subTitleAction, label, style));
                        containers.add(container);
                    }
                }
            } else {
                tab.setName(localeService.getLanguageValue(locale, tab.getName()) + completeDatas.size());
                if (CollectionUtils.isEmpty(completeDatas)) {
                    containers.add(CustomTabContentContainer.emptyContainerUnContainCustomGroup(locale));
                } else {
                    List<UiBotAction> actions = completeUibotModle.getActions();
                    if (CollectionUtils.isEmpty(actions) && UiBotModel.getContentQueryButtonLayout(completeUibotModle.getLayout()) != null) {
                        actions = UiBotModel.getContentQueryButtonLayout(completeUibotModle.getLayout()).getQueryButtons().get(1).getSubmitActions();
                    }
                    for (Map<String, Object> completeData : completeDatas) {
                        CustomTabContentContainer container = new CustomTabContentContainer();
                        container.setContentCmptType(Card.COMPONENT_TYPE);
                        Button button = new Button();
                        String dataId = UUIDUtil.getUuid();
                        if (!CollectionUtils.isEmpty(actions)) {
                            button = Button.createApcWorkShopOnlineCancel(locale, localeService, completeData, actions);
                            button.setId(dataId);

                        }
                        TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
                        detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_CANCEL_DETAIL.toString());
                        detailPage.setRefreshPageId(pageId);
                        detailPage.setDataId(dataId);
                        Map<String, Object> rawData = new HashMap<>(2);
                        rawData.put("data", completeData);
                        rawData.put("pageId", PageSettingIdPresetEnum.MOBILE_ATHENA_APC_WORK_SHOP_ONLINE_CANCEL_DETAIL.toString());
                        detailPage.setRawData(rawData);
                        //TODO 先注释掉S7在改回来
//                        detailPage.setRawData((Map<String, Object>) button.getAction().getRawData());
                        container.setDetailPage(detailPage);
                        ModuleUtils.addRefreshPageId(button, pageId);
                        Card card = Card.createApcWorkShopOnlineCard(tab.getContent(), completeData,
                                locale, localeService, new Button(), "", null, null, 1);
                        //TODO 先注释掉S7在改回来
//                        Card card = Card.createApcWorkShopOnlineCard(tab.getContent(), completeData,
//                                locale, localeService, button, "", null, null, 1);
                        //TODO 先注释掉S7删掉下面这行代码
//                        card.setDisableClick(true);
                        container.setData(card);
                        containers.add(container);
                    }
                }
            }
            tab.setContent(containers);
        }
        return customTabs;
    }
}
