package com.digiwin.mobile.mobileuibot.core.component.tab.customtab;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBar;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBarStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.business.bizprocess.BizProcessDataItem;
import com.digiwin.mobile.mobileuibot.core.component.business.bizprocess.BizProcessDataList;
import com.digiwin.mobile.mobileuibot.core.component.business.bizprocess.BizProcessDataListBuilder;
import com.digiwin.mobile.mobileuibot.core.component.button.SubmitButton;
import com.digiwin.mobile.mobileuibot.core.component.button.SubmitButtonBuilder;
import com.digiwin.mobile.mobileuibot.core.component.list.projectcc.DataItemInTaskList;
import com.digiwin.mobile.mobileuibot.core.component.list.projectcc.PhaseList;
import com.digiwin.mobile.mobileuibot.core.component.list.projectcc.TaskList;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.model.projectcc.ProjectCCTaskItem;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils.localeService;

/**
 * <p>功能描述：自定义多TAB页签组件构造器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomTabsBuilder
 * @Author: Zaregoto
 * @Date: 2021/7/5 23:58
 */
@Component("customTabsBuilder")
public class CustomTabsBuilder implements MobileComponentBuilder<CustomTabs> {

    private static final Logger logger = LoggerFactory.getLogger(CustomTabsBuilder.class);

    @Autowired
    private BizProcessDataListBuilder bizProcessDataListBuilder;

    @Autowired
    private SubmitButtonBuilder submitButtonBuilder;

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public String getMobileComponentType() {
        return "CUSTOM_TABS";
    }

    @Override
    public CustomTabs build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                            Class<CustomTabs> clazz, Object... args) {
        String locale = apiRequest.getLocale();

        Assert.notNull(args, "args must not null!");
        Assert.notEmpty(args, "args must not empty!");
        Assert.notNull(args[0], "args[0] must not null!");
        Assert.isInstanceOf(UiBotLayout.class, args[0],
                "args[0] must be instance of UiBotLayout.class!");
        String projectNo = "";
        String tenantId = "";
        try {
            projectNo = (String) args[2];
            tenantId = (String) args[3];
        } catch (ArrayIndexOutOfBoundsException e) {

        }

        Boolean isPcc = !(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_DETAIL.toString().equals(pageSetting.getPageId())
                || PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_DETAIL.toString().equals(pageSetting.getPageId()));
        UiBotLayout pageSettingLayout = (UiBotLayout) args[0];
        if (null == pageSettingLayout.getMChildren() || pageSettingLayout.getMChildren()
                .isEmpty()) {
            return CustomTabs.createEmpty();
        }
        CustomTabs customTabs = JsonUtil.objectToJavaObject(
                pageSetting.getPageModel().getPageData().get(pageSettingLayout.getSchema()),
                new TypeReference<CustomTabs>() {
                });


        boolean selectable = false;

        for (int i = 0; i < pageSettingLayout.getMChildren().size(); i++) {
            UiBotLayout pageSettingLayoutChild = pageSettingLayout.getMChildren().get(i);
            if (null == pageSettingLayoutChild.getMChildren()
                    || pageSettingLayoutChild.getMChildren().isEmpty()) {
                continue;
            }
            String mBizKey = pageSettingLayoutChild.getMBizKey();

            CustomTab customTab = customTabs.get(i);
            customTab.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, customTab.getName()));
            if (null != pageSettingLayoutChild.getMScrollMode()) {
                customTab.setScrollMode(pageSettingLayoutChild.getMScrollMode());
            }

            List<UiBotLayout> subTabChildrenLayout = pageSettingLayoutChild.getMChildren();
            for (UiBotLayout subTabChildLayout : subTabChildrenLayout) {
                String type = subTabChildLayout.getType();
                String mContentType = subTabChildLayout.getMContentType();
                Boolean mMajor = subTabChildLayout.getMMajor();
                Integer mPosition = subTabChildLayout.getMPosition();
                String finalProjectNo = projectNo;
                Boolean isPccPlan = PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_PLAN_CC_PROJECT_DETAIL.toString().equals(pageSetting.getPageId());

                // FIXME 后面要改成组件生成策略工厂来做，且目前使用字面量为写死的逻辑
                if (PhaseList.COMPONENT_TYPE.equalsIgnoreCase(type) && "PHASE_ITEM".equalsIgnoreCase(
                        mContentType)) {
                    //阶段
                    Assert.notNull(args[1], "args[1] must not null!");
                    Assert.isInstanceOf(List.class, args[1],
                            "args[1] must be instance of List.class!");
                    List<PccProjectTaskInfo> pccProjectTaskInfoList =
                            (List<PccProjectTaskInfo>) args[1];
                    if (CollectionUtils.isEmpty(pccProjectTaskInfoList)) {
                        //没有数据显示空提示组件
                        CustomTabContentContainer<Empty> container =
                                new CustomTabContentContainer<>();
                        Empty empty = Empty.create(LocaleUtil.getMobileTextByKey(locale, "请选择模板，添加任务"));
                        container.setData(empty);
                        container.setContentCmptType(Empty.COMPONENT_TYPE);
                        container.setMajor(mMajor);
                        container.setPosition(mPosition);
                        customTab.addCustomTabContentContainer(container);
                        continue;
                    }

                    // 筛选出第一级的任务，并按业务逻辑(sequence)正序排序
                    List<PccProjectTaskInfo> processedTaskList =
                            pccProjectTaskInfoList.stream().filter(
                                            projectTaskInfo -> projectTaskInfo.getUpperLevelTaskNo()
                                                    .equalsIgnoreCase(projectTaskInfo.getTaskNo()))
                                    .sorted(Comparator.comparingInt(PccProjectTaskInfo::getSequence))
                                    .collect(Collectors.toList());

                    // 体系云未启动项目 不展示说明内容
                    if (!Objects.equals(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_DETAIL.toString(), pageSetting.getPageId())) {
                        // 转换为taskItem后，挂到customTab下
                        String content = "说明：" +
                                "" +
                                "1.蓝色:表示首阶任务，不会下发任务卡执行的任务" +
                                "\n" +
                                "2.浅紫色:表示尾阶任务，会下发任务卡执行的任务" +
                                "\n" +
                                "3.亮蓝色:表示中阶任务，既不是首阶也不是尾阶，不会下发任务卡执行的任务";

                        LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);
                        MessageBar messageBar = MessageBar.create(localeService.getLanguageValue(locale, content),
                                MessageBarStyleTypeEnum.BLACK_WORD_GREEN_BACKGROUDCOLOR.getType(), 59027);
                        CustomTabContentContainer<MessageBar> messageBarContainer =
                                new CustomTabContentContainer<>();
                        messageBarContainer.setData(messageBar);
                        messageBarContainer.setContentCmptType(MessageBar.COMPONENT_TYPE);
                        customTab.addCustomTabContentContainer(messageBarContainer);
                    }
                    // pcc项目追踪和项目计划的任务按照卡片列表的方式展示
                    ZtbViewList stageZtbViewList = new ZtbViewList();
                    stageZtbViewList.setData(processedTaskList.stream().map(
                            projectTaskInfo -> ProjectCCTaskItem.createProjectCard(apiRequest, projectTaskInfo,
                                    pccProjectTaskInfoList, finalProjectNo, pageSetting.getPageId(), isPcc, isPccPlan, false, false)).collect(Collectors.toList()));
                    CustomTabContentContainer<ZtbViewList> stageContainer =
                            new CustomTabContentContainer<>();
                    stageContainer.setData(stageZtbViewList);
                    stageContainer.setContentCmptType(ZtbViewList.COMPONENT_TYPE);
                    customTab.addCustomTabContentContainer(stageContainer);
                } else if (TaskList.COMPONENT_TYPE.equalsIgnoreCase(type) && "TASK_ITEM".equalsIgnoreCase(
                        mContentType) && "CRITICAL_PATH".equalsIgnoreCase(mBizKey)) {
                    //关键路径
                    if (isPcc) {
                        Assert.notNull(args[1], "args[1] must not null!");
                        Assert.isInstanceOf(List.class, args[1],
                                "args[1] must be instance of List.class!");
                        List<PccProjectTaskInfo> pccProjectTaskInfoList =
                                (List<PccProjectTaskInfo>) args[1];

                        List<String> taskNoList = digiwinEspProxyService.getNewProjectCriticalPath(apiRequest.getIamUserToken(), projectNo, tenantId, locale);
                        // TODO PCC2月11日开始用新接口，故注释掉老接口
//                    List<String> taskNoList = digiwinEspProxyService.getProjectCriticalPath(apiRequest.getIamUserToken(), projectNo, tenantId, locale);
                        if (!taskNoList.isEmpty()) {
                            CustomTabContentContainer<ZtbViewList> container =
                                    new CustomTabContentContainer<>();
                            //筛选出关键路径的任务
                            List<PccProjectTaskInfo> criticalPathTaskInfoList
                                    = taskNoList.stream().map(taskNo ->
                                    pccProjectTaskInfoList.stream()
                                            .filter(digiwinAtdmProjectTaskInfo ->
                                                    taskNo.equalsIgnoreCase(digiwinAtdmProjectTaskInfo.getTaskNo()))
                                            .findFirst().orElse(null)).collect(Collectors.toList());
                            criticalPathTaskInfoList.removeAll(Collections.singleton(null));
                            //V1改造，列表改造成卡片列表的结构
                            ZtbViewList criticalPathZtbViewList = new ZtbViewList();
                            criticalPathZtbViewList.setData(criticalPathTaskInfoList.stream().map(
                                    projectCriticalPathTaskInfo -> ProjectCCTaskItem.createProjectCard(apiRequest, projectCriticalPathTaskInfo,
                                            pccProjectTaskInfoList, finalProjectNo, pageSetting.getPageId(), true, isPccPlan, true, false)).collect(Collectors.toList()));
                            container.setData(criticalPathZtbViewList);
                            container.setContentCmptType(ZtbViewList.COMPONENT_TYPE);
                            customTab.setScrollMode(CustomTabScrollModeEnum.TAB_SCROLL.getMode());
                            if (null != mMajor) {
                                container.setMajor(mMajor);
                            }
                            if (null != mPosition) {
                                container.setPosition(mPosition);
                            }
                            customTab.addCustomTabContentContainer(container);
                        } else {
                            //没有关键路径时，显示空提示组件
                            CustomTabContentContainer<Empty> container =
                                    new CustomTabContentContainer<>();
                            Empty empty = Empty.create(LocaleUtil.getMobileTextByKey(locale, "暂无关键路径"));
                            container.setData(empty);
                            container.setContentCmptType(Empty.COMPONENT_TYPE);
                            if (null != mMajor) {
                                container.setMajor(mMajor);
                            }
                            if (null != mPosition) {
                                container.setPosition(mPosition);
                            }
                            customTab.addCustomTabContentContainer(container);
                        }
                    }
                } else if (TaskList.COMPONENT_TYPE.equalsIgnoreCase(type) && "TASK_ITEM".equalsIgnoreCase(
                        mContentType) && "TASK".equalsIgnoreCase(mBizKey)) {
                    //任务列表
                    Assert.notNull(args[1], "args[1] must not null!");
                    Assert.isInstanceOf(List.class, args[1],
                            "args[1] must be instance of List.class!");
                    List<PccProjectTaskInfo> pccProjectTaskInfoList =
                            (List<PccProjectTaskInfo>) args[1];
                    // 筛选出最后一级的任务（没有子任务的任务）
                    List<PccProjectTaskInfo> allLeafTaskInfoList =
                            this.getLeafTaskInfoList(null, pccProjectTaskInfoList);

                    // 逾期的，按逾期天数倒排
                    List<PccProjectTaskInfo> overdueTaskInfoList =
                            allLeafTaskInfoList.stream().filter(PccProjectTaskInfo::isOverdue)
                                    .sorted(Comparator.comparingLong(
                                            PccProjectTaskInfo::getOverduePeriodInDay).reversed())
                                    .collect(Collectors.toList());

                    // 正常进行中的，按计划开始日期正排
                    List<PccProjectTaskInfo> normalDoingTaskInfoList =
                            allLeafTaskInfoList.stream().filter(taskInfo -> !taskInfo.isOverdue())
                                    .filter(PccProjectTaskInfo::isDoing).sorted(
                                            Comparator.comparingLong(
                                                    PccProjectTaskInfo::getPlanStartDateEpochDay))
                                    .collect(Collectors.toList());
                    // 正常未开始的，按计划开始日期正排
                    List<PccProjectTaskInfo> normalTodoTaskInfoList =
                            allLeafTaskInfoList.stream().filter(taskInfo -> !taskInfo.isOverdue())
                                    .filter(PccProjectTaskInfo::isTodo).sorted(
                                            Comparator.comparingLong(
                                                    PccProjectTaskInfo::getPlanStartDateEpochDay))
                                    .collect(Collectors.toList());
                    // 正常已完成的，按计划开始日期正排
                    List<PccProjectTaskInfo> normalFinishedTaskInfoList =
                            allLeafTaskInfoList.stream().filter(taskInfo -> !taskInfo.isOverdue())
                                    .filter(PccProjectTaskInfo::isDone).sorted(
                                            Comparator.comparingLong(
                                                    PccProjectTaskInfo::getPlanStartDateEpochDay))
                                    .collect(Collectors.toList());
                    List<Retractable> retractableList = new ArrayList<>();
                    TaskList taskList = new TaskList();
                    // 转换为taskItem后，挂到customTab下
                    if (!overdueTaskInfoList.isEmpty()) {
                        DataItemInTaskList dataItemInTaskList = new DataItemInTaskList();
                        dataItemInTaskList.setCategoryName(
                                LocaleUtil.getMobileTextByKey(locale, "逾期"));
                        if (isPcc) {
                            retractableList.add(buildRetractable(overdueTaskInfoList, pccProjectTaskInfoList, apiRequest,
                                    finalProjectNo, pageSetting, true, true, false, "逾期"));
                        } else {
                            dataItemInTaskList.setData(overdueTaskInfoList.stream().map(
                                            taskInfo -> ProjectCCTaskItem.createKsc(locale, taskInfo,
                                                    pccProjectTaskInfoList, false, apiRequest.getIamUserToken(), finalProjectNo))
                                    .collect(Collectors.toList()));
                        }
                        taskList.add(dataItemInTaskList);
                    }

                    if (!normalDoingTaskInfoList.isEmpty()) {
                        DataItemInTaskList dataItemInTaskList = new DataItemInTaskList();
                        dataItemInTaskList.setCategoryName(
                                LocaleUtil.getMobileTextByKey(locale, "进行中"));
                        if (isPcc) {
                            retractableList.add(buildRetractable(normalDoingTaskInfoList, pccProjectTaskInfoList, apiRequest,
                                    finalProjectNo, pageSetting, true, true, false, "进行中"));
                        } else {
                            dataItemInTaskList.setData(normalDoingTaskInfoList.stream().map(
                                            taskInfo -> ProjectCCTaskItem.createKsc(locale, taskInfo,
                                                    pccProjectTaskInfoList, false, apiRequest.getIamUserToken(), finalProjectNo))
                                    .collect(Collectors.toList()));
                        }

                        taskList.add(dataItemInTaskList);
                    }

                    if (!normalTodoTaskInfoList.isEmpty()) {
                        DataItemInTaskList dataItemInTaskList = new DataItemInTaskList();
                        dataItemInTaskList.setCategoryName(
                                LocaleUtil.getMobileTextByKey(locale, "未开始"));
                        if (isPcc) {
                            retractableList.add(buildRetractable(normalTodoTaskInfoList, pccProjectTaskInfoList, apiRequest,
                                    finalProjectNo, pageSetting, true, true, false, "未开始"));
                        } else {
                            dataItemInTaskList.setData(normalTodoTaskInfoList.stream().map(
                                            taskInfo -> ProjectCCTaskItem.createKsc(locale, taskInfo,
                                                    pccProjectTaskInfoList, false, apiRequest.getIamUserToken(), finalProjectNo))
                                    .collect(Collectors.toList()));
                        }
                        taskList.add(dataItemInTaskList);
                    }

                    if (!normalFinishedTaskInfoList.isEmpty()) {
                        DataItemInTaskList dataItemInTaskList = new DataItemInTaskList();
                        dataItemInTaskList.setCategoryName(
                                LocaleUtil.getMobileTextByKey(locale, "已完成"));
                        if (isPcc) {
                            retractableList.add(buildRetractable(normalFinishedTaskInfoList, pccProjectTaskInfoList, apiRequest,
                                    finalProjectNo, pageSetting, true, true, false, "已完成"));
                        } else {
                            dataItemInTaskList.setData(normalFinishedTaskInfoList.stream().map(
                                            taskInfo -> ProjectCCTaskItem.createKsc(locale, taskInfo,
                                                    pccProjectTaskInfoList, false, apiRequest.getIamUserToken(), finalProjectNo))
                                    .collect(Collectors.toList()));
                        }

                        taskList.add(dataItemInTaskList);
                    }

                    CustomTabContentContainer<TaskList> container =
                            new CustomTabContentContainer<>();
                    if (isPcc) {
                        List<CustomTabContentContainer> customTabContentContainerList = retractableList.stream().map(retractable -> {
                            CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
                            customTabContentContainer.setContentCmptType(Retractable.COMPONENT_TYPE);
                            customTabContentContainer.setData(retractable);
                            return customTabContentContainer;
                        }).collect(Collectors.toList());
                        customTab.setContent(customTabContentContainerList);
                        customTab.setScrollMode(CustomTabScrollModeEnum.TAB_SCROLL.getMode());
                    } else {
                        container.setData(taskList);
                        container.setContentCmptType(type);
                        customTab.addCustomTabContentContainer(container);
                    }

                    if (null != mMajor) {
                        container.setMajor(mMajor);
                    }
                    if (null != mPosition) {
                        container.setPosition(mPosition);
                    }

                } else if (BizProcessDataList.COMPONENT_TYPE.equalsIgnoreCase(type)
                        && BizProcessDataItem.COMPONENT_TYPE.equalsIgnoreCase(mContentType)) {
                    BizProcessDataList bizProcessDataList =
                            this.bizProcessDataListBuilder.build(apiRequest, pageSetting, pcUiBotModel,
                                    BizProcessDataList.class, subTabChildLayout);
                    selectable =
                            Optional.ofNullable(bizProcessDataList.getSelectable()).orElse(false);

                    customTab.setName(customTab.getName() + " " + bizProcessDataList.bizDataSize());

                    CustomTabContentContainer<BizProcessDataList> container =
                            new CustomTabContentContainer<>();
                    container.setData(bizProcessDataList);
                    container.setContentCmptType(type);
                    if (null != mMajor) {
                        container.setMajor(mMajor);
                    }
                    if (null != mPosition) {
                        container.setPosition(mPosition);
                    }

                    customTab.addCustomTabContentContainer(container);
                } else if (SubmitButton.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                    List<SubmitButton> submitButtonList =
                            this.submitButtonBuilder.build(apiRequest, pageSetting, pcUiBotModel,
                                    SubmitButton.class, subTabChildLayout, selectable);
                    CustomTabContentContainer<List<SubmitButton>> container =
                            new CustomTabContentContainer<>();
                    container.setData(submitButtonList);
                    container.setContentCmptType(type);
                    if (null != mMajor) {
                        container.setMajor(mMajor);
                    }
                    if (null != mPosition) {
                        container.setPosition(mPosition);
                    }

                    customTab.addCustomTabContentContainer(container);
                }
            }
        }
        return customTabs;
    }

    private Retractable buildRetractable(List<PccProjectTaskInfo> taskInfoList, List<PccProjectTaskInfo> pccProjectTaskInfoList,
                                         ApiRequest apiRequest, String finalProjectNo,
                                         PageSetting pageSetting, Boolean isPcc, Boolean isPccPlan, Boolean isCriticalPath, String title) {
        ZtbViewList stageZtbViewList = new ZtbViewList();
        stageZtbViewList.setData(taskInfoList.stream().map(
                projectTaskInfo -> ProjectCCTaskItem.createProjectCard(apiRequest, projectTaskInfo,
                        pccProjectTaskInfoList, finalProjectNo, pageSetting.getPageId(), isPcc, isPccPlan, isCriticalPath, true)).collect(Collectors.toList()));
        Retractable retractable = new Retractable();
        retractable.setStyle(2);
        retractable.setIsExpand(true);
        retractable.setTitle(localeService.getLanguageValue(apiRequest.getLocale(), title + "(" + taskInfoList.size() + ")"));
        retractable.setContent(Collections.singletonList(
                new BaseMobileComponentWrapper<>(
                        stageZtbViewList,
                        ZtbViewList.COMPONENT_TYPE)));
        return retractable;
    }

    /**
     * 获取所有叶子节点的任务列表
     *
     * @param allTaskInfoList
     * @return
     */
    private List<PccProjectTaskInfo> getLeafTaskInfoList(
            final List<PccProjectTaskInfo> rootTaskInfoList,
            final List<PccProjectTaskInfo> allTaskInfoList) {
        List<PccProjectTaskInfo> resultTaskInfoList = new ArrayList<>();
        List<PccProjectTaskInfo> tempRootTaskInfoList = rootTaskInfoList;
        if (rootTaskInfoList == null) {
            tempRootTaskInfoList = this.getRootTaskInfoList(allTaskInfoList);
        }
        for (PccProjectTaskInfo taskInfo : tempRootTaskInfoList) {
            List<PccProjectTaskInfo> childrenTaskList =
                    taskInfo.filterNextLevelProjectTaskInfo(allTaskInfoList);
            if (childrenTaskList.isEmpty()) {
                resultTaskInfoList.add(taskInfo);
            } else {
                resultTaskInfoList.addAll(
                        this.getLeafTaskInfoList(childrenTaskList, allTaskInfoList));
            }
        }
        return resultTaskInfoList;
    }

    /**
     * 获取所有根节点任务列表
     *
     * @param allTaskInfoList
     * @return
     */
    private List<PccProjectTaskInfo> getRootTaskInfoList(
            List<PccProjectTaskInfo> allTaskInfoList) {
        return allTaskInfoList.stream()
                .filter(taskInfo -> taskInfo.getUpperLevelTaskNo().equals(taskInfo.getTaskNo()))
                .collect(Collectors.toList());
    }
}
