package com.digiwin.mobile.mobileuibot.core.component.tab.customtab;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum.MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomTabsComponentBuilder
 * @Author: yanfenga
 * @Date: 2023/8/11
 */
@Slf4j
@Component("customTabsComponentBuilder")
public class CustomTabsComponentBuilder implements MobileComponentBuilder<CustomTabs> {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public String getMobileComponentType() {
        return CustomTabs.COMPONENT_TYPE;
    }

    @Override
    public CustomTabs build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<CustomTabs> clazz, Object... args) {
        CustomTabs result = new CustomTabs();
        switch (Objects.requireNonNull(PageSettingIdPresetEnum.getEnumByName(pageSetting.getPageId()))) {
            case MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_LIST:
            case MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST:
                result = buildWorkingHourReport(apiRequest, pageSetting, pcUiBotModel, clazz, args);
                break;
            default:
                break;
        }
        return result;
    }

    public CustomTabs buildWorkingHourReport(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                             Class<CustomTabs> clazz, Object... args) {
        CustomTabs customTabs = new CustomTabs();
        //根据pageId获取相应默认数据
        Map<String, Object> defaultDataMap = TaskDataExtractUtil.getDefaultData(pageSetting.getPageId());
        String[] leftTitleFields = (String[]) defaultDataMap.get("leftTitleFields");
        String rightTitleField = String.valueOf(defaultDataMap.get("rightTitleField"));
        String[] contentFields = (String[]) defaultDataMap.get("contentFields");
        final int contentFieldsLimit = Integer.parseInt(defaultDataMap.get("contentFieldsLimit").toString());
        Map<String, String> valueToTextMap = (Map<String, String>) defaultDataMap.get("valueToTextMap");

        UiBotPageData uiBotPageData = pcUiBotModel.getPageData();
        String bizDataSchema = pcUiBotModel.searchBizDataSchema();
        //防呆作用
        if (bizDataSchema.isEmpty()) {
            switch (Objects.requireNonNull(PageSettingIdPresetEnum.getEnumByName(pageSetting.getPageId()))) {
                case MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_LIST:
                case MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST:
                    bizDataSchema = "wo_op_report_data";
                    break;
                default:
                    break;
            }
        }
        List<Map<String, Object>> bizDataRaw = (List<Map<String, Object>>) uiBotPageData.get(bizDataSchema);

        // 工时回报需要增加提交校验，工时支援不需要增加提交校验，apc根据is_merge_report来区分
        if (MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST.toString().equalsIgnoreCase(pageSetting.getPageId())) {
            if (!CollectionUtils.isEmpty(bizDataRaw)) {
                bizDataRaw.forEach(item -> {
                    // 工时回报需要增加提交校验，工时支援不需要增加提交校验，apc根据is_merge_report来区分
                    item.put("is_merge_report", true);
                    //「制令上线」选班组A，对应班组报工人员收到「工时回报」和主管收到「进度回报」任务，
                    // 当人员不够需支援时，主管在「进度回报」去请求支援，这是班组B的报工人收到「工时支援」任务，
                    // 去做报工上线时，后台记录的不是支援人的所属班组B，而仍记录的是制令上线时的班组A
                    //[工時支援] 提交入參增加：是否支援(whether_support)=true
                    item.put("whether_support", true);
                });
            }
        }
        //未上线
        CustomTab offLineCustomTab = buildCustomTab(pageSetting.getPageId(), bizDataRaw, pcUiBotModel, false, apiRequest, customTabs, leftTitleFields, rightTitleField, contentFields, contentFieldsLimit, valueToTextMap);
        customTabs.add(offLineCustomTab);
        //已上线
        CustomTab onLineCustomTab = buildCustomTab(pageSetting.getPageId(), bizDataRaw, pcUiBotModel, true, apiRequest, customTabs, leftTitleFields, rightTitleField, contentFields, contentFieldsLimit, valueToTextMap);
        customTabs.add(onLineCustomTab);
        return customTabs;
    }

    /**
     * @param bizDataRaw
     * @param isCheckIn  已上线：true；未上线 false
     * @param apiRequest
     * @return CustomTab
     * @author yanfeng
     */
    private CustomTab buildCustomTab(String pageId, List<Map<String, Object>> bizDataRaw, UiBotModel pcUiBotModel, boolean isCheckIn, ApiRequest apiRequest, CustomTabs customTabs,
                                     String[] leftTitleFields, String rightTitleField, String[] contentFields, int contentFieldsLimit, Map<String, String> valueToTextMap) {
        CustomTab customTab = new CustomTab();

        List<Map<String, Object>> list = bizDataRaw.stream().filter(item -> item.get("is_check_in").equals(isCheckIn)).collect(Collectors.toList());
        //根据op_no进行分组
        Map<String, List<Map<String, Object>>> bizData = groupByFieldMap(list, "op_no");
        int showNum;
        if (isCheckIn) {
            customTabs.setGrayButton(!CollectionUtils.isEmpty(list));
            showNum = list.size();
        } else {
            showNum = bizData.size();
        }
        List<CustomTabContentContainer> customTabContentContainerList = new ArrayList<>();

        // 异常回报允许上传附件
        DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService = SpringContextHolder.getBean(DigiwinKnowledgeMapsProxyService.class);
        Map<String, Object> variableListSimpleMap = digiwinKnowledgeMapsProxyService.getVariableListSimple(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                apiRequest.getLocale(), Arrays.asList("abnormalAllowsUploadingAttachments"));
        if (!CollectionUtils.isEmpty(bizData)) {
            //大于1说明按钮在明细里面
            for (Map.Entry<String, List<Map<String, Object>>> entry : bizData.entrySet()) {
                String subOpSeq = String.valueOf(entry.getValue().get(0).get("sub_op_seq"));
                boolean hasButton = subOpSeq.isEmpty();
                CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();

                if (isCheckIn) {
                    //已上线
                    UiBotExecuteContext executeContext = pcUiBotModel.getExecuteContext();
                    Map<String, Object> businessUnit = (Map<String, Object>) executeContext.get("businessUnit");
                    entry.getValue().get(0).put("eoc_site_id", businessUnit.get("eoc_site_id"));
                    List<Map<String, Object>> qtyInfoList = digiwinEspProxyService.getWoOpReportQtyInfo(
                            apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), buildApcRequest(entry.getValue().get(0), pageId));
                    customTabContentContainer.setContentCmptType(CustomGroup.COMPONENT_TYPE);
                    customTabContentContainer.setData(CustomGroup.create(apiRequest, pcUiBotModel, entry.getValue().get(0), entry.getValue(),
                            hasButton, leftTitleFields, contentFields, contentFieldsLimit,
                            valueToTextMap, isCheckIn, qtyInfoList, variableListSimpleMap));
                } else {
                    //未上线
                    customTabContentContainer.setContentCmptType(Card.COMPONENT_TYPE);
                    customTabContentContainer.setData(Card.create(apiRequest, pcUiBotModel, entry.getValue().get(0), entry.getValue(),
                            hasButton, leftTitleFields, rightTitleField, contentFields, contentFieldsLimit,
                            valueToTextMap, isCheckIn, customTabContentContainer, localeService, variableListSimpleMap));
                }
                customTabContentContainerList.add(customTabContentContainer);
            }
        } else {
            String emptyMsg = "暂无数据";
            CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
            customTabContentContainer.setData(Empty.create(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), emptyMsg), true));
            customTabContentContainer.setContentCmptType(Empty.COMPONENT_TYPE);
            customTabContentContainerList.add(customTabContentContainer);
            customTab.setContent(customTabContentContainerList);
            customTab.setDefaultSelected(isCheckIn ? 0 : 1);
        }
        String tabName = localeService.getLanguageValue(apiRequest.getLocale(), isCheckIn ? "已上线" : "未上线") + " (" + showNum + ")";
        customTab.setName(tabName);
        customTab.setStyle(2);
        customTab.setAlignmentType(1);
        customTab.setContent(customTabContentContainerList);
        return customTab;
    }


    //根据字段，对list数据进行分组
    public Map<String, List<Map<String, Object>>> groupByFieldMap(List<Map<String, Object>> list, String value) {
        Map<String, List<Map<String, Object>>> listMap = new LinkedHashMap<>();
        //根据value值进行分组
        for (Map<String, Object> map : list) {
            List<Map<String, Object>> tmpList = listMap.get(map.get(value));
            if (tmpList == null) {
                tmpList = new ArrayList<>();
                tmpList.add(map);
                listMap.put(String.valueOf(map.get(value)), tmpList);
            } else {
                tmpList.add(map);
            }
        }
        return listMap;
    }

    private Map<String, Object> buildApcRequest(Map<String, Object> woInfoJsonObject, String pageId) {
        Map<String, Object> requestMap = new HashMap<>();
        JSONObject woReportData = new JSONObject();
        woReportData.put("eoc_company_id", woInfoJsonObject.get("eoc_company_id"));
        woReportData.put("eoc_site_id", woInfoJsonObject.get("eoc_site_id"));
        woReportData.put("wo_no", woInfoJsonObject.get("wo_no"));
        woReportData.put("op_seq", woInfoJsonObject.get("op_seq"));
        woReportData.put("category", woInfoJsonObject.get("category"));
        woReportData.put("plan_source", woInfoJsonObject.get("plan_source"));
        woReportData.put("remaining_qty", woInfoJsonObject.get("remaining_qty"));
        woReportData.put("report_qty", woInfoJsonObject.get("report_qty"));
        woReportData.put("plot_no", woInfoJsonObject.get("plot_no"));
        if ("MOBILE_ATHENA_APC_WORKING_HOUR_REPORT_LIST".equals(pageId)) {
            woReportData.put("category", "1");
        }
        if ("MOBILE_ATHENA_APC_SUPPORT_HOUR_REPORT_LIST".equals(pageId)) {
            woReportData.put("category", "2");
        }
        JSONArray array = new JSONArray();
        array.add(woReportData);
        requestMap.put("wo_op_report_data", array);
        return requestMap;
    }

}
