package com.digiwin.mobile.mobileuibot.core.component.tab.customtab;

import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerTabAlignEnum;
import lombok.Data;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Optional;

/**
 * CustomTabs转对象包装处理类
 * 产生原因：应满足前端需求而产生的这个包装类
 * 原来CustomTabs使用方式：1.在MongoDB中配置，2.渲染组装页面时：new CustomTabs
 * 现在CustomTabs使用方式：还跟原来一样使用，组装页面不需要new CustomTabsWrapper来实现
 * CustomTabsWrapper实际使用：
 * 在责任链CustomTabsWrapperPipelineNode类中使用，
 * 会把CustomTabs类转换包装成CustomTabsWrapper返回给前端使用
 *
 * @author yanfeng
 * @date 2023/7/31
 */
@Data
public class CustomTabsWrapper extends BaseMobileComponent implements Serializable {

    private static final long serialVersionUID = -6731991147433960368L;

    private CustomTabs data;

    // 临时解法，解决h5 V2版DSL对账周报tabs详情展示除错误问题
    private CustomTabs content;

    public CustomTabs getContent() {
        return data;
    }

    /**
     * tab内容的滚动模式。默认在tab页签进行滚动
     */
    private Integer scrollMode = CustomTabScrollModeEnum.TAB_SCROLL.getMode();
    /**
     * 1为旧样式，2位新样式
     */
    private Integer style = 1;

    /**
     * 对齐方式
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerTabAlignEnum
     */
    private Integer alignmentType = CustomTabControllerTabAlignEnum.CENTER.getValue();

    /**
     * 默认选中哪一个tab页签
     */
    private Integer defaultSelected = 0;

    /**
     * 背景颜色
     *
     * @see BackgroundColorEnum
     */
    private String backgroundColor;

    public void setScrollMode(Integer scrollMode) {
        if (!CollectionUtils.isEmpty(data)) {
            this.scrollMode = data.get(0).getScrollMode();
        } else {
            this.scrollMode = scrollMode;
        }
    }

    public void setStyle(Integer style) {
        if (!CollectionUtils.isEmpty(data)) {
            this.style = data.get(0).getStyle();
        } else {
            this.style = style;
        }
    }

    public void setAlignmentType(Integer alignmentType) {
        if (!CollectionUtils.isEmpty(data)) {
            this.alignmentType = data.get(0).getAlignmentType();
        } else {
            this.alignmentType = alignmentType;
        }

    }

    public void setDefaultSelected(Integer defaultSelected) {
        if (!CollectionUtils.isEmpty(data)) {
            this.defaultSelected = data.stream().filter(e -> BooleanUtils.isTrue(e.getIsSelected())).findFirst()
                    .map(data::indexOf).orElse(data.get(0).getDefaultSelected());
        } else {
            this.defaultSelected = defaultSelected;
        }
    }

    public void setBackgroundColor(String backgroundColor) {
        if (!CollectionUtils.isEmpty(data)) {
            this.backgroundColor = data.get(0).getBackgroundColor();
        } else {
            this.backgroundColor = backgroundColor;
        }
    }

    public void setBackgroundColor() {
        if (!CollectionUtils.isEmpty(data)) {
            this.backgroundColor = data.get(0).getBackgroundColor();
        }
    }

    @Override
    public String returnComponentType() {
        return CustomTabs.COMPONENT_TYPE;
    }


}
