package com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCardList;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageInfo;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * tab页签内容区域 同content
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CustomTabContentArea implements Serializable {
    private static final long serialVersionUID = -2689889804986579630L;

    /**
     * 主内容区域
     */
    private List<CustomTabContentContainer> bodyArea = new ArrayList<>();
    /**
     * 底部内容区域
     */
    private List<CustomTabContentContainer> bottomArea = new ArrayList<>();
    /**
     * tab下待处理的数量
     */
    private Integer size;

    /**
     * v2版DSL，重置size个数
     */
    public void resetSize() {
        this.size = 0;
        if (CollectionUtils.isEmpty(bodyArea)) {
            return;
        }

        // 是否包含CustomGroup组件
        boolean existCustomGroup = bodyArea.stream()
                .anyMatch(content -> ("DW_" + CustomGroup.COMPONENT_TYPE).equals(content.getContentCmptType()));
        if (existCustomGroup) {
            this.size = 1;
            return;
        }

        // 是否包含cardList组件
        Optional<CustomTabContentContainer> optional = bodyArea.stream()
                .filter(content -> ("DW_" + ZtbViewList.COMPONENT_TYPE).equals(content.getContentCmptType()))
                .findFirst();
        if (optional.isPresent()) {
            ZtbViewList ztbViewList = (ZtbViewList) optional.get().getData();
            if (ztbViewList != null) {
                List<Card> cardList = ztbViewList.getData();
                this.size = CollectionUtils.isEmpty(cardList) ? 0 : cardList.size();
                Optional.ofNullable(ztbViewList.getPagingConfig()).map(ZtbViewList.PagingConfig::getPageInfo).map(PcUiBotPageInfo::getTotalResults).ifPresent(this::setSize);
            }
            return;
        }
        // 是否包含editcardList组件
        Optional<CustomTabContentContainer> editOptional = bodyArea.stream()
                .filter(content -> ("DW_" + EditCardList.COMPONENT_TYPE).equals(content.getContentCmptType()))
                .findFirst();
        if (editOptional.isPresent()) {
            EditCardList editCardList = (EditCardList) editOptional.get().getData();
            if (editCardList != null) {
                List<BaseMobileComponentWrapper<BaseMobileComponent>> contentGroup = editCardList.getContentGroup();
                this.size = CollectionUtils.isEmpty(contentGroup) ? 0 : contentGroup.size();
                Optional.ofNullable(editCardList.getPagingConfig()).map(ZtbViewList.PagingConfig::getPageInfo).map(PcUiBotPageInfo::getTotalResults).ifPresent(this::setSize);
            }
            return;
        }
        // 是否存在空组件
        boolean existEmpty = bodyArea.stream()
                .anyMatch(content -> ("DW_" + Empty.COMPONENT_TYPE).equals(content.getContentCmptType()));
        if (existEmpty) {
            return;
        }
        this.size = 1;
    }
}
