package com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.index.TripartiteTodoList;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.LabelSystemData;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：Tab页签控制器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomTabController
 * @Author: Zaregoto
 * @Date: 2021/11/15 0:15
 */
@Data
public class CustomTabController extends BaseMobileComponent {

    private static final long serialVersionUID = 6349823522671953392L;
    public static final String COMPONENT_TYPE = "CUSTOM_TAB_CONTROLLER";

    @Override
    public String returnComponentType() {
        return CustomTabController.COMPONENT_TYPE;
    }

    /**
     * 是否开启手势滑动切换
     * true表示是，支持左右滑动切换tab。false表示否，不支持
     */
    private Boolean swipeable;
    /**
     * 0-居中对齐，1-左对齐，2-右对齐
     */
    private Integer tabAlign;
    private List<CustomTabControllerItem> tabItems;
    /**
     * 0：水平布局，1：垂直布局
     */
    private Integer tabLayoutType;

    /**
     * 默认选中哪一个tab页签
     */
    private Integer defaultSelected = 0;

    public CustomTabController() {
    }

    public void updateAsyncConfigParam(String iamUserToken, String locale, String clientId, String tenantId) {
        for (CustomTabControllerItem item : this.getTabItems()) {
            if (item.getAsyncForData()) {
                CustomTabControllerItemAsyncConfig asyncConfig = item.getAsyncConfig();
                // 设置当前的iamUserToken与locale
                asyncConfig.setIamUserToken(iamUserToken);
                asyncConfig.setLocale(locale);
                asyncConfig.setClientId(clientId);
                asyncConfig.setTenantId(tenantId);
                // 设置请求地址的hostname为当前工程的外网访问地址
                String configuredUrl = asyncConfig.getRequestUrl();
                String newUrl = AppContext.getBaseUrl() + configuredUrl
                        + "?clientId=" + clientId
                        + "&tenantId=" + tenantId;
                asyncConfig.setRequestUrl(newUrl);

            }
        }
    }

    /**
     * 处理三方待办列表
     *
     * @param iamUserToken
     * @param locale
     * @param clientId
     * @param tenantId
     * @param labelSystemDataList
     */
    public void updateAsyncTripartiteToDoConfigParam(String iamUserToken, String locale, String clientId, String tenantId, List<LabelSystemData> labelSystemDataList) {
        Map<String, Object> map = new HashMap<>();
        List<CustomTabContentContainer> content = new ArrayList<>();
        CustomTabContentContainer<Map<String, Object>> taskContent = new CustomTabContentContainer<>();
        List<TripartiteTodoList> tripartiteTodoLists = new ArrayList<>();
        for (CustomTabControllerItem item : this.getTabItems()) {
            if (item.getAsyncForData()) {
                CustomTabControllerItemAsyncConfig asyncConfig = item.getAsyncConfig();
                asyncConfig.setIamUserToken(iamUserToken);
                asyncConfig.setLocale(locale);
                asyncConfig.setClientId(clientId);
                asyncConfig.setTenantId(tenantId);
                String configuredUrl = asyncConfig.getRequestUrl();
                String newUrl = AppContext.getBaseUrl() + configuredUrl
                        + "?clientId=" + clientId
                        + "&tenantId=" + tenantId;
                asyncConfig.setRequestUrl(newUrl);
                if (ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TRIPARTITE_TODO_LIST.getReuqestId().equalsIgnoreCase(item.getId())) {
                    if (CollectionUtils.isEmpty(labelSystemDataList)) {
                        taskContent.setContentCmptType(TripartiteTodoList.COMPONENT_TYPE);
                        taskContent.setData(map);
                        content.add(taskContent);
                        item.setContent(content);
                        item.setAsyncConfig(null);
                        continue;
                    }
                    labelSystemDataList.forEach(labelSystemData -> {
                        TripartiteTodoList tripartite = new TripartiteTodoList<>();
                        tripartite.setNodeName(labelSystemData.getAppName());
                        tripartite.setNodeId(String.valueOf(labelSystemData.getId()));
                        tripartite.setIsExpand(true);
                        tripartite.setAsyncConfig(asyncConfig);
                        Map<String, Object> rowData = new HashMap<>();
                        rowData.put("id", labelSystemData.getId());
                        rowData.put("appCode", labelSystemData.getAppId());
                        rowData.put("appName", labelSystemData.getAppName());
                        rowData.put("callBackUrl", labelSystemData.getCallBackUrl());
                        rowData.put("protocolType", labelSystemData.getProtocolType());
                        rowData.put("isNeedSsoUrl", labelSystemData.getIsNeedSsoUrl());
                        rowData.put("isFixedRefresh", labelSystemData.getIsFixedRefresh());
                        tripartite.setRawData(rowData);
                        tripartiteTodoLists.add(tripartite);
                    });
                    taskContent.setContentCmptType(TripartiteTodoList.COMPONENT_TYPE);
                    map.put("data", tripartiteTodoLists);
                    taskContent.setData(map);
                    content.add(taskContent);
                    item.setContent(content);
                    item.setAsyncConfig(null);
                }
            }
        }
    }

}