package com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomTabControllerItem
 * @Author: Zaregoto
 * @Date: 2021/11/15 0:18
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CustomTabControllerItem extends BaseMobileComponent {
    private static final long serialVersionUID = -2768946841484721201L;
    public static final String COMPONENT_TYPE = "CUSTOM_TAB_CONTROLLER_ITEM";

    @Override
    public String returnComponentType() {
        return CustomTabControllerItem.COMPONENT_TYPE;
    }

    private String id;
    /**
     * 是否使用异步方式请求数据
     * true表示是，后续需要使用asyncConfig内的配置；false表示否，直接使用content、desc、name、scrollMode来渲染
     */
    private Boolean asyncForData = false;
    /**
     * 异步请求的配置
     * 前端将本节点参数作为POSTBody往后端请求
     */
    private CustomTabControllerItemAsyncConfig asyncConfig;
    private List<CustomTabContentContainer> content = new ArrayList<>();
    private CustomTabContentArea contentArea;
    /**
     * tab页签内容使用字段
     * 可选。可选值：content, contentArea。用于告诉前端使用哪个字段解析并渲染tab页签内容。若字段不存在或无值，则默认使用content字段解析，做到向下兼容
     */
    private String contentUseSchema;
    private String desc;
    private String jumpPageId;
    private String jumpPageTitle;
    /**
     * tab页签内容布局类型	0：水平布局，1：垂直布局
     */
    private Integer layoutType;
    private String name;
    /**
     * 为true时，不显示标签头，且只显示第一页标签内容
     */
    private Boolean showTitle = true;
    private Boolean scrollable;
    /**
     * 是否刷新当前tab签的已有数据	0：不刷新；1：刷新；
     */
    private Integer flushType;
    private Integer emptyMode = CustomTabControllerItemEmptyModeEnum.EMPTY_DATA_AND_UI_WITH_HIDE_MORE.getValue();
    private Boolean isExpand = false;
    private Boolean isSearched = false;
    /**
     * 异步请求 接口 返回数据结构类型
     * 1:当前组件结构，2:uibotMode结构
     *
     * @see CustomTabControllerItemAsyncResponseTypeEnum
     */
    private Integer asyncResponseType = CustomTabControllerItemAsyncResponseTypeEnum.CUSTOM_TAB_CONTROLLER_ITEM.getType();

    public static CustomTabControllerItem createAsyncData(String name,
                                                          CustomTabContentContainer content, CustomTabControllerItemEmptyModeEnum emptyModeEnum) {
        CustomTabControllerItem item = new CustomTabControllerItem();
        item.setAsyncForData(false);
        item.setAsyncConfig(CustomTabControllerItemAsyncConfig.createEmpty());
        if (null != name) {
            item.setName(name);
        }
        if (null != content) {
            item.getContent().add(content);
        }
        item.setEmptyMode(emptyModeEnum == null ?
                CustomTabControllerItemEmptyModeEnum.EMPTY_DATA_AND_UI_WITH_HIDE_MORE.getValue() : emptyModeEnum.getValue());

        return item;
    }

    public static CustomTabControllerItem createAsyncData(String name,
                                                          List<CustomTabContentContainer> content,
                                                          CustomTabControllerItemEmptyModeEnum emptyModeEnum,
                                                          Boolean isSearched) {
        CustomTabControllerItem item = new CustomTabControllerItem();
        item.setAsyncForData(false);
        item.setAsyncConfig(CustomTabControllerItemAsyncConfig.createEmpty());
        if (null != name) {
            item.setName(name);
        }
        if (null != content) {
            item.setContent(content);
        }
        item.setEmptyMode(emptyModeEnum == null ?
                CustomTabControllerItemEmptyModeEnum.EMPTY_DATA_AND_UI_WITH_HIDE_MORE.getValue() : emptyModeEnum.getValue());
        item.setIsSearched(isSearched);
        return item;
    }

}
