package com.digiwin.mobile.mobileuibot.core.component.tab.standardtab;

import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.PcmFilterUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.BusinessRawData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardProcessedCondition;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：设计器--标准Tab页签控制器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: StandardTabs.java
 * @Author: wangjwc
 * @Date: created at 2024/2/28 10:26
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class StandardTabs extends BaseMobileComponent {
    private static final long serialVersionUID = -8026287517050798816L;
    public static final String COMPONENT_TYPE = "STANDARD_TABS";

    /**
     * 0-居中对齐，1-左对齐，2-右对齐
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabControllerTabAlignEnum
     */
    private Integer tabAlign;
    private List<StandardTabsItem> tabItems;

    /**
     * 默认选中哪一个tab页签
     */
    private Integer defaultSelected = 0;

    @Override
    public String returnComponentType() {
        return StandardTabs.COMPONENT_TYPE;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        // PCM_项目预算签核定制
        this.customizePcmBudgetProjectApprovals(data, executeContext);
        List<StandardTabsItem> tabItems = this.getTabItems();
        if (!CollectionUtils.isEmpty(tabItems)) {
            UiBotDesignerRenderService uiBotDesignerRenderService = SpringContextHolder.getBean(UiBotDesignerRenderService.class);
            for (StandardTabsItem tabItem : tabItems) {
                StandardTabsContentArea contentArea = tabItem.getContentArea();
                uiBotDesignerRenderService.buildCmptDsl(cmptContext, executeContext, contentArea.getBodyArea(), data, mobilePageRawData);
                if (CollectionUtils.isEmpty(contentArea.getBodyArea())) {
                    // tab下无组件，添加空组件
                    contentArea.getBodyArea().add(UiBotRenderData.createEmptyWrapper());
                }
                contentArea.resetSize();
                contentArea.resetFilterFlag();
            }
            this.defaultSelected = this.buildDefaultSelected(cmptContext, executeContext, tabItems);
        }
    }

    private Integer buildDefaultSelected(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, List<StandardTabsItem> tabItems) {
        if (PcmFilterUtil.isPcmCustomized(executeContext.getTmActivityId(), executeContext.getTmProjectId())) {
            // PCM_项目预算签核定制
            return this.customizePcmBudgetProjectApprovalsDefaultSelected(cmptContext, tabItems);
        }
        Integer defaultSelected = this.getDefaultSelected();
        if (CollectionUtils.isEmpty(tabItems)) {
            return defaultSelected;
        }
        return defaultSelected;
    }

    private Integer customizePcmBudgetProjectApprovalsDefaultSelected(ComponentContext cmptContext, List<StandardTabsItem> tabItems) {
        Integer defaultSelected = this.getDefaultSelected();
        if (CollectionUtils.isEmpty(tabItems)) {
            return defaultSelected;
        }
        // cardList筛选
        String businessType = cmptContext.getRawData().getBusinessType();
        if (null == businessType) {
            return defaultSelected;
        }
        BusinessRawData businessRawData = cmptContext.getRawData().getBusinessRawData();
        if (null == businessRawData) {
            return defaultSelected;
        }
        if (BusinessTypeEnum.FILTER.getValue().equalsIgnoreCase(businessType) && businessRawData.getRefreshPageId().equalsIgnoreCase(cmptContext.getPageId())) {
            String componentId = businessRawData.getComponentId();
            if (StringUtils.hasLength(componentId)) {
                for (int i = 0; i < tabItems.size(); i++) {
                    StandardTabsContentArea contentArea = tabItems.get(i).getContentArea();
                    if (!CollectionUtils.isEmpty(contentArea.getBodyArea())) {
                        if (contentArea.getBodyArea().stream().anyMatch(wrapper -> componentId.equals(wrapper.returnComponentId()))) {
                            defaultSelected = i;
                        }
                    }
                }
            }
        }
        return defaultSelected;
    }

    private void customizePcmBudgetProjectApprovals(Map<String, Object> data, PcUiBotExecuteContext executeContext) {
        if (!PcmFilterUtil.isPcmCustomized(executeContext.getTmActivityId(), executeContext.getTmProjectId())) {
            return;
        }
        // PCM_项目预算签核定制 --- 构建tab--通用
        this.customizePcmBudgetProjectApprovalsTab(data);
    }

    private void customizePcmBudgetProjectApprovalsTab(Map<String, Object> data) {
        List<StandardTabsItem> rawTabsItem = this.getTabItems();
        List<StandardTabsItem> newTabItems = new ArrayList<>();
        // 默认只显示分项汇总
        rawTabsItem.stream().filter(item -> "0".equals(item.getId())).findFirst().ifPresent(newTabItems::add);
        this.setTabItems(newTabItems);

        List<Map<String, Object>> projectBudgetItemDetail = (List<Map<String, Object>>) data.get("project_budget_item_detail");
        if (CollectionUtils.isEmpty(projectBudgetItemDetail)) {
            return;
        }
        StandardTabsItem materialTabTemplate = rawTabsItem.stream().filter(item -> "1".equals(item.getId())).findFirst().orElse(new StandardTabsItem());
        StandardTabsItem expensesTabTemplate = rawTabsItem.stream().filter(item -> "2".equals(item.getId())).findFirst().orElse(new StandardTabsItem());
        projectBudgetItemDetail.forEach(item -> {
            // 预算分项类型： 1.材料; 2.费用
            String budgetItemType = (String) item.get("budget_item_type");
            if ("1".equals(budgetItemType)) {
                this.handleMobilePathAndSchema(materialTabTemplate);
                StandardTabsItem materialTab = JsonUtil.objectToJavaObject(materialTabTemplate, StandardTabsItem.class);
                materialTab.setName((String) item.get("budget_item_name"));
                // 处理cardList中Card过滤数据条件
                this.handleFilterCondition(materialTab);
                newTabItems.add(materialTab);
            } else if ("2".equals(budgetItemType)) {
                this.handleMobilePathAndSchema(expensesTabTemplate);
                StandardTabsItem expensesTab = JsonUtil.objectToJavaObject(expensesTabTemplate, StandardTabsItem.class);
                expensesTab.setName((String) item.get("budget_item_name"));
                // 处理cardList中Card过滤数据条件
                this.handleFilterCondition(expensesTab);
                newTabItems.add(expensesTab);
            }
        });
    }

    private void handleMobilePathAndSchema(StandardTabsItem tabTemplate) {
        StandardTabsContentArea contentArea = tabTemplate.getContentArea();
        if (contentArea == null) {
            return;
        }
        contentArea.getBodyArea().stream()
                .filter(bodyArea -> ("DW_" + ZtbViewList.COMPONENT_TYPE).equals(bodyArea.getComponentType()))
                .forEach(wrapper -> {
                    wrapper.setMobilePath(wrapper.getMobilePath() + "&");
                    wrapper.setSchema(wrapper.getSchema() + "&");
                    wrapper.getData().setSchema(wrapper.getSchema());
                    wrapper.getData().setMobilePath(wrapper.getMobilePath());
                });
    }

    private void handleFilterCondition(StandardTabsItem tabTemplate) {
        StandardTabsContentArea contentArea = tabTemplate.getContentArea();
        if (contentArea == null) {
            return;
        }
        contentArea.getBodyArea().stream().filter(bodyArea -> ("DW_" + ZtbViewList.COMPONENT_TYPE).equals(bodyArea.getComponentType()))
                .forEach(cardList -> {
                    ZtbViewList component = (ZtbViewList) cardList.getData();
                    Card card = component.getCardListData();
                    if (card != null) {
                        Card.DesignerRawCard data = card.getData();
                        if (data != null) {
                            List<CardProcessedCondition> processedConditionList = data.getProcessedConditionList();
                            if (!CollectionUtils.isEmpty(processedConditionList)) {
                                processedConditionList.forEach(processedCondition -> processedCondition.setValue(tabTemplate.getName()));
                            }
                        }
                    }
                });
    }
}
