package com.digiwin.mobile.mobileuibot.core.component.tab.standardtab;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapperJsonDeserializer;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.editcardlist.EditCardList;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * <p>功能描述：标准tab页签内容区域</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: StandardTabsContentArea.java
 * @Author: wangjwc
 * @Date: created at 2024/2/28 10:34
 */
@Data
public class StandardTabsContentArea implements Serializable {
    private static final long serialVersionUID = 5720598812507992970L;

    /**
     * 是否是筛选后的数据 --- 暂未使用
     */
    private Boolean filterFlag;
    /**
     * tab下数据的数量
     */
    private Integer size;
    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyArea;

    public List<BaseMobileComponentWrapper<BaseMobileComponent>> getBodyArea() {
        return bodyArea = bodyArea == null ? new ArrayList<>() : bodyArea;
    }

    public void resetSize() {
        this.size = 0;
        if (CollectionUtils.isEmpty(bodyArea)) {
            return;
        }
        // 是否包含cardList组件
        Optional<BaseMobileComponentWrapper<BaseMobileComponent>> optional = bodyArea.stream()
                .filter(content -> ("DW_" + ZtbViewList.COMPONENT_TYPE).equals(content.getComponentType()))
                .findFirst();
        if (optional.isPresent()) {
            ZtbViewList ztbViewList = (ZtbViewList) optional.get().getData();
            if (ztbViewList != null) {
                List<Card> cardList = ztbViewList.getData();
                this.size = CollectionUtils.isEmpty(cardList) ? 0 : cardList.size();
                Optional.ofNullable(ztbViewList.getPagingConfig()).map(ZtbViewList.PagingConfig::getPageInfo).map(PcUiBotPageInfo::getTotalResults).ifPresent(this::setSize);
            }
            return;
        }
        // 是否包含editcardList组件
        Optional<BaseMobileComponentWrapper<BaseMobileComponent>> editOptional = bodyArea.stream()
                .filter(content -> ("DW_" + EditCardList.COMPONENT_TYPE).equals(content.getComponentType()))
                .findFirst();
        if (editOptional.isPresent()) {
            EditCardList editCardList = (EditCardList) editOptional.get().getData();
            if (editCardList != null) {
                List<BaseMobileComponentWrapper<BaseMobileComponent>> contentGroup = editCardList.getContentGroup();
                this.size = CollectionUtils.isEmpty(contentGroup) ? 0 : contentGroup.size();
                Optional.ofNullable(editCardList.getPagingConfig()).map(ZtbViewList.PagingConfig::getPageInfo).map(PcUiBotPageInfo::getTotalResults).ifPresent(this::setSize);
            }
            return;
        }
        // 是否存在空组件
        boolean existEmpty = bodyArea.stream()
                .anyMatch(content -> ("DW_" + Empty.COMPONENT_TYPE).equals(content.getComponentType()));
        if (existEmpty) {
            return;
        }
        this.size = 1;
    }

    public void resetFilterFlag() {
        this.filterFlag = false;
        if (CollectionUtils.isEmpty(bodyArea)) {
            return;
        }
        // 是否包含cardList组件
        bodyArea.stream()
                .filter(content -> ("DW_" + ZtbViewList.COMPONENT_TYPE).equals(content.getComponentType())
                        || ("DW_" + EditCardList.COMPONENT_TYPE).equals(content.getComponentType()))
                .findFirst()
                .ifPresent(wapper -> {
                    if (wapper.getData() instanceof ZtbViewList) {
                        this.filterFlag = BooleanUtils.isTrue(((ZtbViewList) wapper.getData()).getFilterFlag());
                    } else if (wapper.getData() instanceof EditCardList) {
                        this.filterFlag = BooleanUtils.isTrue(((EditCardList) wapper.getData()).getFilterFlag());
                    }
                });
    }
}
