package com.digiwin.mobile.mobileuibot.core.component.tab.tabs;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabScrollModeEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * tabs组件-tab页签
 *
 * @author zhangjj
 * @date 2021/12/1 0001 15:55
 */
@Data
public class TabItem implements Serializable {
    private static final long serialVersionUID = -1916099779459212548L;

    /**
     * tab签名称
     */
    private String name;

    /**
     * 描述信息
     */
    private String desc;

    /**
     * todo 详情页面
     */
    private Object detailPage;

    private List<TabItemCard> content;

    /**
     * 页签下的全局rawData，需要在每个itemCard点击事件的时候，将这个塞到action的rawData里面
     */
    private Map<String, Object> tabItemRawData = new HashMap<>(1);
    /**
     * 切换到当前tab签时，是否展示底部按钮。无值按true处理
     */
    private Boolean showBottomButton = true;

    /**
     * 空组件
     */
    private Empty empty;

    /**
     * tab签滚动模式
     */
    private Integer mScrollMode = CustomTabScrollModeEnum.CONTENT_SCROLL.getMode();

    public TabItem() {
    }

    public TabItem(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Object getDetailPage() {
        return detailPage;
    }

    public void setDetailPage(Object detailPage) {
        this.detailPage = detailPage;
    }

    public List<TabItemCard> getContent() {
        return content;
    }

    public void setContent(List<TabItemCard> content) {
        this.content = content;
    }

    public Boolean getShowBottomButton() {
        return showBottomButton;
    }

    public void setShowBottomButton(Boolean showBottomButton) {
        this.showBottomButton = showBottomButton;
    }

    public Empty getEmpty() {
        return empty;
    }

    public void setEmpty(Empty empty) {
        this.empty = empty;
    }
}
