package com.digiwin.mobile.mobileuibot.core.component.tab.tabs;

import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentPerson;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListOption;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum.*;

/**
 * tabs组件-卡片
 *
 * @author zhangjj
 * @date 2021/12/1 0001 15:36
 */
public class TabItemCard extends BaseMobileComponent {
    private static final long serialVersionUID = 780903839636552720L;
    public static final String COMPONENT_TYPE = "TABS_ITEM";


    //创建排序规则 请求支援、异常回报、进度回报、数量转移
    //MOBILE_ATHENA_APC_COMMON_ATTACHMENT_DETAIL_PAGE--附件历程
    //MOBILE_ATHENA_APC_COMMON_ATTACHMENT_UPLOAD_PAGE--上传附件
    //MOBILE_ATHENA_APC_REMARK_DETAIL_CONFIRM--进度回报
    //MOBILE_ATHENA_APC_SUPPORT_BOTTOM--请求支援
    //MOBILE_ATHENA_APC_ABNORMAL_REPORT_DETAIL--异常回报
    //MOBILE_ATHENA_APC_TRANSFER_QUANTITY_SFT_DETAILS--数量转移
    private static final String[] ORDER = {
            MOBILE_ATHENA_APC_COMMON_ATTACHMENT_DETAIL_PAGE.toString(),
            MOBILE_ATHENA_APC_COMMON_ATTACHMENT_UPLOAD_PAGE.toString(),
            MOBILE_ATHENA_APC_SUPPORT_BOTTOM.toString(),
            MOBILE_ATHENA_APC_ABNORMAL_REPORT_DETAIL.toString(),
            MOBILE_ATHENA_APC_REMARK_DETAIL_CONFIRM.toString(),
            MOBILE_ATHENA_APC_TRANSFER_QUANTITY_SFT_DETAILS.toString()
    };

    @Override
    public String returnComponentType() {
        return TabItemCard.COMPONENT_TYPE;
    }

    /**
     * 子列表条目底部按钮操作
     */
    private UiBotModel buttonLayout;
    /**
     * 概要字段
     */
    private List<TabItemCardContent> content;

    private BaseMobileComponentPerson person;

    private TabItemCardTitle title;

    private TabItemCardDetailPage detailPage;

    /**
     * 1-推出打开全新页面，2-底部弹窗打开
     */
    private Integer openType;

    /**
     * 图示字段
     */
    private Picture pictureThumb;

    public TabItemCard() {
        this.content = new ArrayList<>();
    }

    public static String formatSeconds(double totalSeconds) {
        // 判断是否为负数
        boolean isNegative = totalSeconds < 0;

        // 取绝对值并四舍五入到最近的秒数
        int roundedSeconds = (int) Math.round(Math.abs(totalSeconds));
        int hours = roundedSeconds / 3600;
        int minutes = (roundedSeconds % 3600) / 60;
        int seconds = roundedSeconds % 60;

        // 格式化为 hh:mm:ss
        String formattedTime = String.format("%02d:%02d:%02d", hours, minutes, seconds);

        // 如果是负数，加上负号
        if (isNegative) {
            formattedTime = "-" + formattedTime;
        }

        return formattedTime;
    }

    /**
     * 进度回报任务-card卡片创建
     *
     * @param apiRequest
     * @param pcUiBotModel
     * @param mainDataInfo
     * @param hasButton
     * @param rightTitleField
     * @param contentFields
     * @param contentFieldCreateLimit
     * @param valueToTextMap
     * @param progressPercentageArr
     * @param total                   进度回报列表数据总数
     * @return
     */
    public static Card createApcScheduleReportCard(ApiRequest apiRequest, UiBotModel pcUiBotModel, Map<String, Object> mainDataInfo,
                                                   boolean hasButton, String rightTitleField, String[] contentFields, int contentFieldCreateLimit,
                                                   Map<String, String> valueToTextMap, int[] progressPercentageArr, LocaleService localeService, int total) {
        String locale = apiRequest.getLocale();
        String dataId = apiRequest.getDataId();

        int contentFieldCreatedCount = 0;

        Card card = new Card();
        card.setTitle(MapUtils.getString(mainDataInfo, "op_name"));

        String productionStatus = MapUtils.getString(mainDataInfo, "production_status");
        if (StringUtils.hasLength(productionStatus)) {
            //有且仅当为4的时候，异常要能点击跳转
            String endValue = "";
            if ("4".equalsIgnoreCase(productionStatus)) {
                endValue = ">";
                Action subTitleAction = new Action();
                subTitleAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_APC_PROJECT_SCHEDULE_REPORT_WAIT_DEAL_LIST.toString());
                subTitleAction.setJumpPageTitle(localeService.getLanguageValue(locale, "待处理异常清单"));
                subTitleAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
                Map<String, Object> rawData = new HashMap<>(1);
                List<Map<String, Object>> datas = new ArrayList<>(1);
                Map<String, Object> woOpReportData = new HashMap<>(1);
                woOpReportData.put("eoc_company_id", ModuleUtils.emptyString(mainDataInfo.get("eoc_company_id")));
                woOpReportData.put("eoc_site_id", ModuleUtils.emptyString(mainDataInfo.get("eoc_site_id")));
                woOpReportData.put("eoc_region_id", ModuleUtils.emptyString(mainDataInfo.get("eoc_region_id")));
                woOpReportData.put("wo_no", ModuleUtils.emptyString(mainDataInfo.get("wo_no")));
                woOpReportData.put("plot_no", ModuleUtils.emptyString(mainDataInfo.get("plot_no")));
                woOpReportData.put("op_seq", ModuleUtils.emptyString(mainDataInfo.get("op_seq")));
                datas.add(woOpReportData);
                rawData.put("wo_op_report_data", datas);
                subTitleAction.setRawData(rawData);
                card.setSubTitleAction(subTitleAction);
            }
            productionStatus = valueToTextMap.getOrDefault(rightTitleField + "_" + productionStatus, productionStatus);
            card.setSubTitle(localeService.getLanguageValue(locale, productionStatus)+ endValue);
        }

        //多字段拼接
        List<CardContent.MultiValueObj.MultiValueObjData> standTotalMulList = new ArrayList<CardContent.MultiValueObj.MultiValueObjData>();
        CardContent.MultiValueObj standTotalMultiValueObj = new CardContent.MultiValueObj();
        standTotalMultiValueObj.setIsLineFeed(false);
        standTotalMultiValueObj.setSeparator("");
        // 概要字段
        for (String contentField : contentFields) {
            String value = String.valueOf(mainDataInfo.getOrDefault(contentField, ""));
            //进度百分比
            if ("progress_percentage".equalsIgnoreCase(contentField) && StringUtils.hasLength(value)) {
                int valueInt = (int) Double.parseDouble(value);
                value = valueInt + "%";
            }
            //待出站量
            if ("remaining_qty".equalsIgnoreCase(contentField) && StringUtils.hasLength(value)) {
                int valueInt = (int) Double.parseDouble(value);
                value = StrUtil.toString(valueInt);
            }
            //合并单号
            if ("merge_no".equalsIgnoreCase(contentField) && !StringUtils.hasLength(value)) {
                //空的时候默认显示"-"
                value = "-";
            }
            //标准工时
            if ("standard_work_hours".equalsIgnoreCase(contentField)) {
                //格式转换
                contentFieldCreatedCount--;
                if (StringUtils.hasLength(value)) {
                    value = formatSeconds(Double.valueOf(value));
                } else {
                    value = "-";
                }
            }
            //合并工时
            if ("total_work_hours".equalsIgnoreCase(contentField)) {
                //格式转换
                contentFieldCreatedCount--;
                if (StringUtils.hasLength(value)) {
                    value = formatSeconds(Double.valueOf(value));
                } else {
                    value = "-";
                }
            }
            if (value.trim().isEmpty()) {
                // 只读的话，空值，移动不显示，故不处理
                continue;
            }
            String labelStr = valueToTextMap.getOrDefault(contentField, contentField);
            CardContent cardContent = CardContent.create(localeService.getLanguageValue(locale, labelStr), value, 1);
            if ("standard_work_hours".equalsIgnoreCase(contentField) || "total_work_hours".equalsIgnoreCase(contentField)) {
                CardContent.MultiValueObj.MultiValueObjData multiValueObjData = new CardContent.MultiValueObj.MultiValueObjData();
                multiValueObjData.setSchema(cardContent.getSchema());
                multiValueObjData.setFullPath("");
                multiValueObjData.setLabel(localeService.getLanguageValue(locale, labelStr));
                multiValueObjData.setValue(value);
                standTotalMulList.add(multiValueObjData);
                if (standTotalMulList.size() < 2) {
                    card.getContent().add(cardContent);
                }
            } else if ("merge_no".equalsIgnoreCase(contentField)) {
                if (standTotalMulList.size() > 1) {
                    standTotalMultiValueObj.setData(standTotalMulList);
                    card.getContent().get(card.getContent().size() - 1).setMultiValue(standTotalMultiValueObj);
                }
                card.getContent().add(cardContent);
            } else {
                card.getContent().add(cardContent);
            }
            contentFieldCreatedCount++;
            if (contentFieldCreatedCount == contentFieldCreateLimit) {
                break;
            }
        }

        Action processReportAction = new Action();
        UiBotExecuteContext executeContext = pcUiBotModel.getExecuteContext();
        Map<String, Object> businessUnit = (Map<String, Object>) executeContext.get("businessUnit");
        Map<String, Object> commonRawDataMap = new HashMap<>();
        commonRawDataMap.put("businessUnit", businessUnit);
        commonRawDataMap.put("executeContext", executeContext);

        if (hasButton) {
            // 异常回报允许上传附件
            DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService = SpringContextHolder.getBean(DigiwinKnowledgeMapsProxyService.class);
            Map<String, Object> variableListSimpleMap = digiwinKnowledgeMapsProxyService.getVariableListSimple(apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                    apiRequest.getLocale(), Arrays.asList("abnormalAllowsUploadingAttachments"));

            List<BottomButtonDigiwinAthena> buttonList = new ArrayList<>(4);
            generateQuantityTransferMethod(pcUiBotModel, mainDataInfo, localeService, total, locale, buttonList, variableListSimpleMap);
            double progressPercentage = generateProgressPercentageMethod(mainDataInfo, pcUiBotModel, apiRequest, progressPercentageArr, total, dataId, processReportAction, buttonList);
            // 异常回报按钮生成
            Action abnormalReportAction = Action.createAbnormalReportAction(locale, mainDataInfo, pcUiBotModel, businessUnit,
                    executeContext, commonRawDataMap, dataId);
            BottomButtonDigiwinAthena abnormalReportButton = BottomButtonDigiwinAthena.createAbnormalReportButton(locale, abnormalReportAction);
            // 3表示已完成，4表示异常
            if (!"3".equalsIgnoreCase(productionStatus) && progressPercentage < 100) {
                //只有当它的进度不是"已完成"或者进度值小于100的时候才会生成异常回报按钮
                buttonList.add(abnormalReportButton);
            }
            //对原本按钮...中的子按钮做处理
            List<BottomButtonDigiwinAthena> tempChildrenList = buttonList.stream()
                    .filter(button -> button.getChildren() != null && !button.getChildren().isEmpty()) // 过滤掉没有子元素的按钮
                    .flatMap(button -> button.getChildren().stream())
                    .collect(Collectors.toList());
            buttonList.removeIf(button -> button.getChildren() != null && !button.getChildren().isEmpty());
            buttonList.addAll(tempChildrenList);
            List<Map<String, Object>> woOpReportDataList = Collections.singletonList(mainDataInfo);
            Iterator<BottomButtonDigiwinAthena> iterator = buttonList.iterator();
            while (iterator.hasNext()) {
                BottomButtonDigiwinAthena button = iterator.next();
                Action action = button.getAction();
                if (action != null) {
                    if (MOBILE_ATHENA_APC_REMARK_DETAIL_CONFIRM.toString().equals(action.getJumpPageId())) {
                        if (woOpReportDataList.get(0).get("weather_transfer_bool") instanceof Boolean) {
                            if ((Boolean) woOpReportDataList.get(0).get("weather_transfer_bool")) {
                                iterator.remove();
                            }
                        }
                    }
                }
            }

            // 排序集合
            // 创建orderMap
            Map<String, Integer> orderMap = new HashMap<>();
            for (int i = 0; i < ORDER.length; i++) {
                orderMap.put(ORDER[i], i);
            }
            Collections.sort(buttonList, new Comparator<BottomButtonDigiwinAthena>() {
                @Override
                public int compare(BottomButtonDigiwinAthena o1, BottomButtonDigiwinAthena o2) {
                    // 获取o1和o2的jumpPageId
                    String jumpPageId1 = o1.getAction().getJumpPageId();
                    String jumpPageId2 = o2.getAction().getJumpPageId();
                    // 处理可能的null值
                    Integer index1 = orderMap.get(jumpPageId1);
                    Integer index2 = orderMap.get(jumpPageId2);
                    // 如果找不到索引，设置为最大值，确保未知值排在最后
                    if (index1 == null) index1 = Integer.MAX_VALUE;
                    if (index2 == null) index2 = Integer.MAX_VALUE;

                    return Integer.compare(index1, index2);
                }
            });
            //排序完如果按钮大于三个，则将多余的按钮都放到子按钮数组中
            if (buttonList.size() > 3) {
                BottomButtonDigiwinAthena athena = new BottomButtonDigiwinAthena();
                athena.setName("...");
                for (int i = 0; i < buttonList.size() - 2; i++) {
                    athena.addChildBottomButton(buttonList.get(i));
                }
                List<BottomButtonDigiwinAthena> newButtonList = new ArrayList<>();
                newButtonList.add(athena);
                if (buttonList.size() >= 2) {
                    newButtonList.add(buttonList.get(buttonList.size() - 2));
                    newButtonList.add(buttonList.get(buttonList.size() - 1));
                }
                buttonList = newButtonList;
            }
            List<Button> transalateButtonList1 = new ArrayList<>();
            //用于刷新机制用故将所有的action传递refreshPageId
            buttonList.stream().forEach(button -> {
                if (button.getAction() != null) {
                    button.getAction().setRefreshPageId(apiRequest.getPageId());
                }
                transalateButtonList1.add(button);
            });
            card.setButtonList(transalateButtonList1);
        }
        return card;
    }


    public static double generateProgressPercentageMethod(Map<String, Object> mainDataInfo, UiBotModel pcUiBotModel, ApiRequest apiRequest, int[] progressPercentageArr,
                                                          int total, String dataId, Action processReportAction, List<BottomButtonDigiwinAthena> buttonList) {
        String locale = apiRequest.getLocale();

        // 进度回报按钮生成
        boolean hasCheck = "4".equalsIgnoreCase(String.valueOf(mainDataInfo.get("production_status"))) ? true : false;
        double progressPercentage = Double.parseDouble(String.valueOf(mainDataInfo.get("progress_percentage")));
        int hasCheckValue = 100;
        SingleSelectList singleSelectList = new SingleSelectList();
        List<SingleSelectListOption> optionList = new ArrayList<>();
        for (int i = 0; i < progressPercentageArr.length; i++) {
            boolean selected = progressPercentageArr[i] == progressPercentage ? true : false;
            String checkTip = "";
//            if (hasCheck) {
//                checkTip = LocaleUtil.getMobileTextByKey(locale, "制程状态为异常时，目前进度不能提交") + progressPercentageArr[i] + "%";
//            }
            optionList.add(SingleSelectListOption.create(progressPercentageArr[i], selected, false, hasCheckValue, checkTip));
        }
        singleSelectList.setTitle(LocaleUtil.getMobileTextByKey(locale, "进度百分比"));
        singleSelectList.setStyle(2);
        singleSelectList.setOptionList(optionList);
        singleSelectList.setRequired(true);

        // 进度回报备注详情页提交按钮
        List<BottomButtonDigiwinAthena> remarkDetailBottomButtonList = new ArrayList<>();
        remarkDetailBottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(locale));
        Map<String, Object> remarkDetailButtomRawData = new HashMap<>();
        remarkDetailButtomRawData.put("iamUserToken", apiRequest.getIamUserToken());
        remarkDetailButtomRawData.put("locale", locale);
        remarkDetailButtomRawData.put("clientId", apiRequest.getClientId());

        List<Map<String, Object>> woOpReportDataList = Collections.singletonList(mainDataInfo);

        Map<String, Object> submitWoOpReportData = new HashMap<>();
        submitWoOpReportData.put("wo_op_report_data", woOpReportDataList);
        remarkDetailButtomRawData.put("data", submitWoOpReportData);
        List<UiBotAction> uiBotActionList = pcUiBotModel.getLayout().stream().filter(layout -> "apc_project_schedule-task-detail-waitting".equals(layout.getType()))
                .findFirst()
                .map(UiBotLayout::getActions)
                .orElse(Collections.emptyList());
        Optional<UiBotAction> uiBotActionOptional = uiBotActionList.stream().filter(layout -> "esp_wo.op.report.progress.info.process".equals(layout.getActionId()))
                .findFirst();
        if (uiBotActionOptional.isPresent()) {
            remarkDetailButtomRawData.put("action", uiBotActionOptional.get());
        }
        Map<String, Object> extendFields = new HashMap<>();
        Map<String, Object> processReportParameter = new HashMap<>();
        Map<String, String> processCategory = new HashMap<>();
        processCategory.put("process_category", "1");
        for (Map<String, Object> woOpReportData : woOpReportDataList) {
            woOpReportData.putAll(processCategory);
        }
        processReportParameter.putAll(processCategory);
        processReportParameter.put("wo_op_report_data", woOpReportDataList);
        extendFields.put("parameter", processReportParameter);
        extendFields.put("actionId", "wo.op.progress.validate");
        remarkDetailButtomRawData.put("extendFields", extendFields);
        remarkDetailButtomRawData.put("total", total);
        // 按钮为进度提交
        remarkDetailButtomRawData.put("type", "apc_ProgressToSubmit");
        BottomButtonDigiwinAthena submitButton = BottomButtonDigiwinAthena.createProcessReportSubmitButton(locale, remarkDetailButtomRawData);
        ModuleUtils.addRefreshPageId(submitButton, apiRequest.getPageId());
        remarkDetailBottomButtonList.add(submitButton);

//        Action remarkOnlineAction = new Action();
//        remarkOnlineAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_REMARK_DETAIL_CONFIRM.toString());
//        remarkOnlineAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());

        Map<String, Object> processReportRawData = new HashMap<>();
        processReportRawData.put("data", mainDataInfo);
        processReportRawData.put("buttonList", remarkDetailBottomButtonList);

        UiBotModel dynamicsUiBotModel = UiBotModel.emptyUiBotModel();

        UiBotLayout uiBotLayout = new UiBotLayout("progress_percentage", SingleSelectList.COMPONENT_TYPE);
        dynamicsUiBotModel.setLayout(Collections.singletonList(uiBotLayout));
        UiBotPageData uiBotPageData = new UiBotPageData();
        uiBotPageData.put(uiBotLayout.getSchema(), singleSelectList);
        dynamicsUiBotModel.setPageData(uiBotPageData);
        processReportRawData.put("dynamics_uiBotModel", dynamicsUiBotModel);

        processReportAction.setRawData(processReportRawData);
        // plan_source:	1.MKP 2.SFT；
        /*   int planSource = (int) Double.parseDouble(mainDataInfo.get("plan_source").toString());
        if (1 == planSource) { todo 应用无法完成开发，先注释
            processReportAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_MKP_DETAIL.toString());
        }
        if (2 == planSource) {
            processReportAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_PROJECT_SCHEDULE_REPORT_DETAIL.toString());
        }*/
        processReportAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_REMARK_DETAIL_CONFIRM.toString());
        processReportAction.setDataId(dataId);
        processReportAction.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());

        processReportAction.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "进度回报"));

        BottomButtonDigiwinAthena processReportButton = BottomButtonDigiwinAthena.createProcessReportButton(locale, processReportAction);
        buttonList.add(processReportButton);
        return progressPercentage;
    }

    public static void generateQuantityTransferMethod(UiBotModel pcUiBotModel, Map<String, Object> mainDataInfo, LocaleService localeService,
                                                      int total, String locale, List<BottomButtonDigiwinAthena> buttonList, Map<String, Object> variableListSimpleMap) {
        // 异常回报允许上传附件开关打开，才展示附件历程和上传附件两个按钮
        Boolean abnormalAllowsUploadingAttachments = Optional.ofNullable(variableListSimpleMap).map(map -> MapUtils.getBoolean(map, "abnormalAllowsUploadingAttachments")).orElse(false);
        if (BooleanUtils.isTrue(abnormalAllowsUploadingAttachments)) {
            buttonList.add(BottomButtonDigiwinAthena.createApcAttachmentDetailButton(mainDataInfo, locale, localeService));
            buttonList.add(BottomButtonDigiwinAthena.createApcAttachmentUploadButton(mainDataInfo, "1", locale, localeService));
        }

        // 新增请求支援按钮
        BottomButtonDigiwinAthena supportButton = BottomButtonDigiwinAthena.createSupportAction(
                pcUiBotModel, locale, localeService, mainDataInfo);
        buttonList.add(supportButton);

        //进度管控方式依数量一律出现转移按钮，依工时只有当进度小于100且剩余数量大于1且can_transfer为true才出现转移按钮
        if (isShowTransferQuantityButton(mainDataInfo)) {
            // 新增数量转移按钮
            BottomButtonDigiwinAthena transferQuantityButton = BottomButtonDigiwinAthena.createTransferQuantityAction(
                    pcUiBotModel, locale, localeService, mainDataInfo, total);
            buttonList.add(transferQuantityButton);
        }
    }

    /**
     *  转移数量按钮显示条件
     *  进度管控方式依数量（true），一律出现转移按钮，
     *  进度管控方式依工时(false)，只有当进度小于100且剩余数量大于1且can_transfer为true才出现转移按钮
     */
    private static boolean isShowTransferQuantityButton(Map<String, Object> mainDataInfo) {
        // 进度管控方式
        boolean weatherTransferBool = MapUtils.getBooleanValue(mainDataInfo, "weather_transfer_bool");
        if (weatherTransferBool) {
            return true;
        }

        if (ObjectUtils.isNotEmpty(mainDataInfo.get("progress_percentage"))
                && ObjectUtils.isNotEmpty(mainDataInfo.get("remaining_qty"))
                && ObjectUtils.isNotEmpty(mainDataInfo.get("can_transfer"))
        ) {
            int parseInt = Double.valueOf(String.valueOf(mainDataInfo.get("progress_percentage"))).intValue();
            int remainingQty = Double.valueOf(String.valueOf(mainDataInfo.get("remaining_qty"))).intValue();
            boolean canTransfer = MapUtils.getBooleanValue(mainDataInfo, "can_transfer");
            return parseInt < 100 && remainingQty > 1 && canTransfer;
        }
        return false;
    }

    public List<TabItemCardContent> getContent() {
        return content;
    }

    public void setContent(List<TabItemCardContent> content) {
        this.content = content;
    }

    public BaseMobileComponentPerson getPerson() {
        return person;
    }

    public void setPerson(BaseMobileComponentPerson person) {
        this.person = person;
    }

    public TabItemCardTitle getTitle() {
        return title;
    }

    public void setTitle(TabItemCardTitle title) {
        this.title = title;
    }

    public TabItemCardDetailPage getDetailPage() {
        return detailPage;
    }

    public void setDetailPage(TabItemCardDetailPage detailPage) {
        this.detailPage = detailPage;
    }

    public Integer getOpenType() {
        return openType;
    }

    public void setOpenType(Integer openType) {
        this.openType = openType;
    }

    public UiBotModel getButtonLayout() {
        return buttonLayout;
    }

    public void setButtonLayout(UiBotModel buttonLayout) {
        this.buttonLayout = buttonLayout;
    }

    public Picture getPictureThumb() {
        return pictureThumb;
    }

    public void setPictureThumb(Picture pictureThumb) {
        this.pictureThumb = pictureThumb;
    }

}
