package com.digiwin.mobile.mobileuibot.core.component.tab.tabs;

import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * tabs组件-卡片概要字段
 *
 * @author zhangjj
 * @date 2021/12/1 0001 15:46
 */
@Data
public class TabItemCardContent implements Serializable {
    private static final long serialVersionUID = -8148275570880117331L;

    private String label;

    /**
     * value的数据类型
     * AOMOUNT：金额类型；LOADING：loading标签样式；OVERDUE：逾期标签样式
     */
    private String type;

    private String value;

    /**
     * label样式类型
     * <p>
     * 1：黑色，普通型文本。2：灰色，弱化型文本
     */
    protected Integer labelStyleType;

    /**
     * value样式类型
     * <p>
     * 1：黑色，普通型文本。2：灰色，弱化型文本
     */
    protected Integer valueStyleType;

    /**
     * 对齐方式
     */
    protected Integer alignmentType = 1;

    /**
     * 点击事件
     * 当action不为空且action.type不为空时，value右侧展示可点击按钮
     */
    protected Action action;

    /**
     * 多字段
     * @param label
     * @param labelStyleType
     * @param valueStyleType
     * @param value
     * @return
     */
    protected TabItemMultiValue multiValue;

    public static TabItemCardContent create(String label, Integer labelStyleType, Integer valueStyleType, String value) {
        TabItemCardContent tabItemCardContent = new TabItemCardContent();
        tabItemCardContent.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
        tabItemCardContent.setLabel(label);
        tabItemCardContent.setLabelStyleType(labelStyleType);
        tabItemCardContent.setValueStyleType(valueStyleType);
        tabItemCardContent.setValue(value);
        return tabItemCardContent;
    }
}
