package com.digiwin.mobile.mobileuibot.core.component.tab.tabs;

import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotDesignParameter;
import lombok.Data;
import org.springframework.util.Assert;

import java.io.Serializable;
import java.util.Map;

/**
 * tabs组件-
 *
 * @author zhangjj
 * @date 2021/12/1 0001 15:55
 */
@Data
public class TabItemCardDetailPage implements Serializable {
    private static final long serialVersionUID = 7975512714850195355L;

    private String dataId;
    private ApiExtraParameter extraParameter;
    private String pageId;
    private String pageTitle;
    private String refreshPageId;
    private Map<String, Object> rawData;

    /**
     * 点击事件类型 -- V2版，card点击弹窗方式展示类型
     *
     * @see ActionTypeEnum
     */
    protected Integer type;

    /**
     * 运行态的扩展字段结构
     */
    private UiBotDesignParameter designParameter;

    public TabItemCardDetailPage() {
    }


    public static TabItemCardDetailPage create(String locale, String dataId, ApiExtraParameter extraParameter, String pageId, ApiRawData rawData) {
        Assert.notNull(dataId, "dataId must not null!");
        Assert.notNull(extraParameter, "ApiExtraParameter must not null!");
        Assert.notNull(pageId, "pageId must not null!");

        TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
        detailPage.setDataId(dataId);
        detailPage.setExtraParameter(extraParameter);
        detailPage.setPageId(pageId);
        detailPage.setRawData(rawData);

        return detailPage;
    }

    public static TabItemCardDetailPage create(String locale, String dataId, ApiExtraParameter extraParameter, String pageId, String refreshPageId, ApiRawData rawData) {
        Assert.notNull(dataId, "dataId must not null!");
        Assert.notNull(extraParameter, "ApiExtraParameter must not null!");
        Assert.notNull(pageId, "pageId must not null!");

        TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
        detailPage.setDataId(dataId);
        detailPage.setExtraParameter(extraParameter);
        detailPage.setPageId(pageId);
        detailPage.setRefreshPageId(refreshPageId);
        detailPage.setRawData(rawData);

        return detailPage;
    }

}
