package com.digiwin.mobile.mobileuibot.core.component.tab.tabs;

import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import lombok.Data;
import org.springframework.util.Assert;

import java.io.Serializable;
import java.util.List;

/**
 * tabs组件-卡片标题字段
 *
 * @author zhangjj
 * @date 2021/12/1 0001 15:45
 */
@Data
public class TabItemCardTitle implements Serializable {
    private static final long serialVersionUID = -6164835876227267156L;
    private List<String> leftTitle;
    private String rightTitle;
    private Action rightAction;
    /**
     * 放在左侧标题右边的标签
     */
    private List<Tag> leftTags;

    public static TabItemCardTitle create(List<String> leftTitle, String rightTitle) {
        Assert.notNull(leftTitle, "lefttitle in dataitem cannot be null");
        TabItemCardTitle title = new TabItemCardTitle();
        if (leftTitle.size() > 3) {
            title.setLeftTitle(leftTitle.subList(0, 3));
        } else {
            title.setLeftTitle(leftTitle);
        }
        title.setRightTitle(rightTitle);

        return title;
    }

    public static TabItemCardTitle create(List<String> leftTitle, String rightTitle, Action rightAction) {
        Assert.notNull(leftTitle, "lefttitle in dataitem cannot be null");
        TabItemCardTitle title = new TabItemCardTitle();
        if (leftTitle.size() > 3) {
            title.setLeftTitle(leftTitle.subList(0, 3));
        } else {
            title.setLeftTitle(leftTitle);
        }
        title.setRightTitle(rightTitle);
        title.setRightAction(rightAction);

        return title;
    }

}
