package com.digiwin.mobile.mobileuibot.core.component.tab.tabs;

import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.TableUiBotParser;
import com.digiwin.mobile.mobileuibot.task.model.TaskDetailItemDetail;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * tabs组件
 *
 * @author zhangjj
 * @date 2021/12/1 0001 15:32
 */
@Data
public class TabsComponent extends ArrayList<TabItem> implements Serializable, MobileComponent {
    public static final String COMPONENT_TYPE = "TABS";
    private static final long serialVersionUID = -1279402152063640208L;

    /**
     * 判断是否置灰底部按钮（仅用于APC的工时支援）
     */
    private Boolean grayButton;

    public TabsComponent() {
    }

    public static TabsComponent createEmpty() {
        return new TabsComponent();
    }

    @Override
    public String returnComponentType() {
        return TabsComponent.COMPONENT_TYPE;
    }

    /**
     * 新建一个只有一个tab的tabs组件
     *
     * @param tableLayout
     * @param tablePageData
     * @param tableName
     * @return
     */
    public static TabsComponent build(UiBotLayout tableLayout, UiBotPageData tablePageData, String tableName) {
        TabsComponent tabsComponent = new TabsComponent();
        TabItem tabItem = new TabItem();
        tabItem.setShowBottomButton(true);
        tabsComponent.add(tabItem);
        tabItem.setName(tableName);
        List<TabItemCard> cardList = new ArrayList<>();
        tabItem.setContent(cardList);
        List<List<ParseFieldData>> fieldDataListList = TableUiBotParser.parseTableUiBotData(tableLayout, tablePageData);
        for (List<ParseFieldData> fieldDataList : fieldDataListList) {
            TabItemCard card = new TabItemCard();
            cardList.add(card);
            List<TabItemCardContent> contentList = new ArrayList<>();
            card.setContent(contentList);
            for (ParseFieldData fieldData : fieldDataList) {
                if ("string".equalsIgnoreCase(fieldData.getType())) {
                    continue;
                }
                if (card.getTitle() == null) {
                    TabItemCardTitle title = new TabItemCardTitle();
                    List<String> leftTitleList = new ArrayList<>();
                    leftTitleList.add((String) fieldData.getData());
                    title.setLeftTitle(leftTitleList);
                    title.setRightTitle("");
                    card.setTitle(title);
                } else if (contentList.size() < 3) {
                    TabItemCardContent content = new TabItemCardContent();
                    content.setLabel(fieldData.getLabel());
                    content.setValue((String) fieldData.getData());
                    content.setLabelStyleType(2);
                    content.setValueStyleType(1);
                    contentList.add(content);
                }
            }
            TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
            detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ECN_PROJECT_ITEM_DETAIL.toString());
            detailPage.setDataId("");
            Map<String, Object> rawData = new HashMap<>();
            rawData.put("data", fieldDataList);
            //needTitle为true表示详情页把第一个字段当标题使用
            rawData.put("needTitle", true);
            detailPage.setRawData(rawData);
            card.setDetailPage(detailPage);
        }
        return tabsComponent;
    }

    /**
     * 往tabs组件添加一个tab
     *
     * @param tableLayout
     * @param tablePageData
     * @param tableName
     */
    public void addTab(UiBotLayout tableLayout, UiBotPageData tablePageData, String tableName) {
        TabItem tabItem = new TabItem();
        this.add(tabItem);
        tabItem.setName(tableName);
        tabItem.setShowBottomButton(false);
        List<TabItemCard> cardList = new ArrayList<>();
        tabItem.setContent(cardList);
        List<List<ParseFieldData>> fieldDataListList = TableUiBotParser.parseTableUiBotData(tableLayout, tablePageData);
        for (List<ParseFieldData> fieldDataList : fieldDataListList) {
            TabItemCard card = new TabItemCard();
            cardList.add(card);
            List<TabItemCardContent> contentList = new ArrayList<>();
            card.setContent(contentList);
            for (ParseFieldData fieldData : fieldDataList) {
                if ("string".equalsIgnoreCase(fieldData.getType())) {
                    continue;
                }
                if (card.getTitle() == null) {
                    TabItemCardTitle title = new TabItemCardTitle();
                    List<String> leftTitleList = new ArrayList<>();
                    leftTitleList.add((String) fieldData.getData());
                    title.setLeftTitle(leftTitleList);
                    title.setRightTitle("");
                    card.setTitle(title);
                } else if (contentList.size() < 3) {
                    TabItemCardContent content = new TabItemCardContent();
                    content.setLabel(fieldData.getLabel());
                    content.setValue((String) fieldData.getData());
                    content.setLabelStyleType(2);
                    content.setValueStyleType(1);
                    contentList.add(content);
                }
            }
            TabItemCardDetailPage detailPage = new TabItemCardDetailPage();
            detailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_ECN_PROJECT_ITEM_DETAIL.toString());
            detailPage.setDataId("");
            Map<String, Object> rawData = new HashMap<>();
            rawData.put("data", fieldDataList);
            //needTitle为true表示详情页把第一个字段当标题使用
            rawData.put("needTitle", true);
            detailPage.setRawData(rawData);
            card.setDetailPage(detailPage);
        }
    }

    /**
     * 单头处理
     *
     * @param uiBotModel
     * @param taskDetailItemDetail
     */
    public static void handleHead(UiBotModel uiBotModel, TaskDetailItemDetail taskDetailItemDetail, boolean first) {
        List<String> targetLayoutTypeList = new ArrayList<>();
        targetLayoutTypeList.add("LABEL");
        List<String> parentLayoutTypeList = new ArrayList<>();
        parentLayoutTypeList.add("FORM_LIST");
        UiBotModel labelUiBotModel = uiBotModel.searchPcTargetModel(targetLayoutTypeList, parentLayoutTypeList, true);
        List<UiBotLayout> labelLayoutList = labelUiBotModel.getLayout();
        for (UiBotLayout layout : labelLayoutList) {
            Field field = Field.create(layout.getHeaderName(), layout.getType(),
                    (String) labelUiBotModel.getPageData().get(layout.getSchema()), layout.getSchema());
            if (StringUtils.hasLength(field.getValue())) {
                field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
                field.setLabelStyleType(1);
                field.setValueStyleType(2);
                taskDetailItemDetail.put(layout.getSchema(), field);
            }
            if (first) {
                UiBotLayout applayout = new UiBotLayout();
                applayout.setSchema(layout.getSchema());
                applayout.setType(Field.COMPONENT_TYPE);
                taskDetailItemDetail.addActualLayout(applayout);
            }
        }
    }

}
