package com.digiwin.mobile.mobileuibot.core.component.tab.tabs;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponentBuilder;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TabsComponentBuilder
 * @Author: Liux
 * @Date: 2022年6月30日 13点34分
 */
@Component("tabsComponentBuilder")
public class TabsComponentBuilder implements MobileComponentBuilder<TabsComponent> {

    private static final Logger logger = LoggerFactory.getLogger(TabsComponentBuilder.class);
    @Autowired
    private LocaleService localeService;

    @Override
    public String getMobileComponentType() {
        return TabsComponent.COMPONENT_TYPE;
    }

    @Override
    public TabsComponent build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel, Class<TabsComponent> clazz, Object... args) {
        TabsComponent result = new TabsComponent();
        switch (PageSettingIdPresetEnum.getEnumByName(pageSetting.getPageId())) {
            default:
                break;
        }
        return result;
    }
}
