package com.digiwin.mobile.mobileuibot.core.component.tab.tabscroll;

import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TabScrollContainer implements Serializable, MobileComponent {
    private static final long serialVersionUID = -1584554407530218850L;

    public static final String COMPONENT_TYPE = "TAB_SCROLL_CONTAINER";

    /**
     * 内容区域
     */
    private List<CustomTabContentContainer> bodyArea = new ArrayList<>();
    /**
     * 头部区域
     */
    private List<CustomTabContentContainer> headArea = new ArrayList<>();

    @Override

    public String returnComponentType() {
        return TabScrollContainer.COMPONENT_TYPE;
    }
}
