package com.digiwin.mobile.mobileuibot.core.component.table;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.CardListToTableRawData;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDataItem;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.table.TableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.table.TableRenderSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

import static com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils.localeService;

/**
 * 表格组件
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Table extends BaseMobileComponent {
    private static final long serialVersionUID = 4974745692854908746L;

    public static final String COMPONENT_TYPE = "TABLE";

    @Override
    public String returnComponentType() {
        return Table.COMPONENT_TYPE;
    }

    /**
     * 表名
     */
    private String name;

    private String countNumText;
    private List chooseDate;
    /**
     * 数据多时，表格进行隐藏行的配置
     */
    private TableHiddenConfig hiddenConfig;
    /**
     * 表格样式 0:代表无任何样式，1:奇偶行背景色不同
     */
    private Integer style;
    /**
     * 表格的行内容
     */
    private List<Map<String, Object>> rows = new ArrayList<>(6);
    /**
     * 冻结至某列，默认为0，不冻结
     */
    private Integer columnFreeze = 0;
    /**
     * 表格的表头
     *
     * @return
     */
    private TableHeader tableHeader;

    /**
     * 默认横屏
     */
    private Boolean defaultLandscape;
    /**
     * 是否支持横竖屏
     */
    private Boolean isLandscape;
    private List<BottomButtonDigiwinAthena> buttonList;


    public static Table create(UiBotLayout uiBotLayout, UiBotPageData pageData, List<Map<String, Object>> humanResourceLoadList, String locale, String dateId) {
        Table table = new Table();
        Integer useMember = 0;

        Map<String, Object> tableParams = (Map<String, Object>) pageData.get(uiBotLayout.getSchema());

        //塞表的隐藏条件
        Map<String, Object> hiddenConfig = (Map<String, Object>) tableParams.get("hiddenConfig");
        TableHiddenConfig tableHiddenConfig = new TableHiddenConfig();
        tableHiddenConfig.setHiddenCount((Integer) hiddenConfig.get("hiddenCount"));
        tableHiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByDatabaseKey(locale, (String) hiddenConfig.get("hiddenExpandContent")) + ">");
        tableHiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByDatabaseKey(locale, (String) hiddenConfig.get("hiddenUnexpandContent")) + "<");
        table.setHiddenConfig(tableHiddenConfig);
        //塞表的样式
        table.setStyle((Integer) tableParams.get("style"));


        Map<String, Object> tableHeaderParams = (Map<String, Object>) tableParams.get("tableHeader");
        List<Map<String, Object>> headerDatasetParams = (List<Map<String, Object>>) tableHeaderParams.get("headerDataset");
        List rows = table.getRows();
        if (humanResourceLoadList != null && humanResourceLoadList.size() > 0) {
            humanResourceLoadList.sort((o1, o2) -> {
                String dept1 = (String) o1.get("department_no");
                String dept2 = (String) o2.get("department_no");
                if (dept1.compareTo(dept2) > 0) {
                    return 1;
                } else if (dept1.compareTo(dept2) < 0) {
                    return -1;
                } else {
                    return 0 - dept1.compareTo(dept2);
                }
            });
            for (Map<String, Object> humanResourceLoad : humanResourceLoadList) {
                if (0.0 < (Double) humanResourceLoad.get("remaining_capacity")) {
                    Map<String, Object> row = new HashMap<>(headerDatasetParams.size());
                    useMember++;
                    for (Map<String, Object> header : headerDatasetParams) {
                        header.put("content", LocaleUtil.getMobileTextByDatabaseKey(locale, (String) header.get("content")));
                        row.put("id", UUIDUtil.getLongUuid());
                        String id = (String) header.get("id");
                        //空余产能
                        if ("total_plan_work_hours".equals(id)) {
                            //塞表的日期
                            List<Map<String, Object>> chooseDate = (List) tableParams.get("chooseData");
                            //表示未来一周的数据
                            if ("0".equals(dateId)) {
                                for (Map<String, Object> date : chooseDate) {
                                    if (dateId.equals(date.get("id"))) {
                                        date.put("selected", true);
                                    } else {
                                        date.put("selected", false);
                                    }
                                }
                                ArrayList<Map<String, Object>> weekInfos = (ArrayList<Map<String, Object>>) humanResourceLoad.get("week_info");
                                double countNums = 0;
                                for (Map<String, Object> weekInfo : weekInfos) {
                                    countNums += (double) weekInfo.get(header.get("id"));
                                }
                                row.put(id, countNums);
                            } else if ("1".equals(dateId)) {
                                for (Map<String, Object> date : chooseDate) {
                                    if (dateId.equals(date.get("id"))) {
                                        date.put("selected", true);
                                    } else {
                                        date.put("selected", false);
                                    }
                                }
                                ArrayList<Map<String, Object>> monthInfos = (ArrayList<Map<String, Object>>) humanResourceLoad.get("month_info");
                                double countNums = 0;
                                for (Map<String, Object> monthInfo : monthInfos) {
                                    countNums += (double) monthInfo.get(header.get("id"));
                                }
                                row.put(id, countNums);
                            }

                            table.setChooseDate(chooseDate);
                        } else {
                            row.put(id, (humanResourceLoad.get(header.get("id")).equals("") ? "-" : humanResourceLoad.get(header.get("id"))));
                        }
                    }
                    rows.add(row);
                }
            }
        } else {
            //塞表的日期
            List<Map<String, Object>> chooseDate = (List) tableParams.get("chooseData");
            //表示未来一周的数据
            if ("0".equals(dateId)) {
                for (Map<String, Object> date : chooseDate) {
                    if (dateId.equals(date.get("id"))) {
                        date.put("selected", true);
                    } else {
                        date.put("selected", false);
                    }
                }
            } else if ("1".equals(dateId)) {
                for (Map<String, Object> date : chooseDate) {
                    if (dateId.equals(date.get("id"))) {
                        date.put("selected", true);
                    } else {
                        date.put("selected", false);
                    }
                }
            }
            table.setChooseDate(chooseDate);
        }
        //塞表身
        table.setRows(rows);
        //塞表头
        TableHeader tableHeader = new TableHeader();
        tableHeader.setHeaderDataset(ModuleUtils.listMapToListT(headerDatasetParams, TableHeaderDataSet.class));
        tableHeader.setTableFixed((Boolean) tableHeaderParams.get("tableFixed"));
        table.setTableHeader(tableHeader);

        //塞统计参数
        table.setCountNumText(LocaleUtil.getMobileTextByKey(locale, "剩余可用人力共") + useMember + LocaleUtil.getMobileTextByKey(locale, "名"));
        return table;
    }

    /**
     * web端Uibot开窗表格，转换为移动端表格
     *
     * @param uiBotLayout
     * @param pageData
     * @param executeContext
     * @param locale
     * @param useCollapse
     * @return
     */
    public static Table create(UiBotLayout uiBotLayout, UiBotPageData pageData,
                               UiBotExecuteContext executeContext, String locale, Boolean useCollapse) {
        Table table = new Table();
        TableHeader tableHeader = new TableHeader();
        table.setTableHeader(tableHeader);

        // 表schema
        table.setSchema(uiBotLayout.getSchema());

        // 表格表头设置
        List<UiBotTableColumnDefinition> columnDefinitions = uiBotLayout.getColumnDefs();
        List<UiBotTableColumn> columns = UiBotTableColumnDefinition.decomposeTableColumnDefinitions(columnDefinitions);
        String path = CollectionUtils.isEmpty(columns) ? "" : columns.get(0).getPath();

        List<TableHeaderDataSet> tableHeaderDataSetList = TableHeaderDataSet.getTableHeaderDataSetList(columns, false);
        tableHeader.setHeaderDataset(tableHeaderDataSetList);

        // 表格在移动端默认冻结首行（标题行）
        tableHeader.setTableFixed(true);

        // 表格数据内容
        List<Map<String, Object>> rows = table.getRows();

        List<Map<String, Object>> tableDatas = ModuleUtils.getDataListByPath(path, pageData);
        for (Map<String, Object> tableData : tableDatas) {
            Map<String, Object> row = new HashMap<>(6);
            List<TableColumnConfig> tableColumnConfigs = new ArrayList<>();
            for (UiBotTableColumn column : columns) {
                row.put(column.getSchema(), tableData.get(column.getSchema()));
                /**
                 * 单元格配置
                 */
                tableColumnConfigs.add(TableColumnConfig.create(column, executeContext));
            }
            row.put("columnConfig", tableColumnConfigs);
            rows.add(row);
        }
        // 表格冻结至第1列
        table.setColumnFreeze(1);

        // 表数据的隐藏条件
        if (useCollapse) {
            TableHiddenConfig tableHiddenConfig = new TableHiddenConfig();
            tableHiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey(locale, "查看更多"));
            table.setHiddenConfig(tableHiddenConfig);
        }

        return table;
    }


    /**
     * 根据一个中间态DSL的数据描述，创建一个移动端表格组件对象<br/>
     * 未来随着组件类挪入athenamobile-uibot-component模块，该方法要转到AgileDataIntermediateDataItem对象内
     *
     * @param locale               语言别
     * @param intermediateDataItem 中间态DSL中的一项数据
     * @param useCollapse          是否需要收起展开功能隐藏部分数据
     * @param hiddenHintContent    收起时的文字提示
     * @param needFilterAndSort    是否需要过滤和排序功能
     * @param needCompoundColumn
     * @param executeContext       中间态DSL中的上下文
     * @return
     */
    public static Table create(String locale, AgileDataIntermediateDataItem intermediateDataItem,
                               boolean useCollapse, String hiddenHintContent, boolean needFilterAndSort,
                               boolean needCompoundColumn, UiBotExecuteContext executeContext) {
        Table table = new Table();
        TableHeader tableHeader = new TableHeader();
        table.setTableHeader(tableHeader);

        // 表名和schema
        table.setName(intermediateDataItem.getShowName());
        table.setSchema(intermediateDataItem.getBizDataId());

        // 表格在移动端默认冻结首行（标题行）
        tableHeader.setTableFixed(true);
        // 表格冻结至第1列
        table.setColumnFreeze(1);

        TableRenderSetting tableRenderSetting = intermediateDataItem.getTableRenderSetting();
        // 表格表头设置（用代码开关区分两种方式，防止以后有需要）
        if (!needCompoundColumn) {
            List<TableColumnDefinition> columnDefinitionList = tableRenderSetting.getColumns();
            List<UiBotTableColumn> columns = TableColumnDefinition.decomposeTableColumnDefinitions(columnDefinitionList);
            if (CollectionUtils.isEmpty(columns)) {
                return table;
            }
            List<TableHeaderDataSet> tableHeaderDataSetList = TableHeaderDataSet.getTableHeaderDataSetList(columns, needFilterAndSort);
            tableHeader.setHeaderDataset(tableHeaderDataSetList);

            // 表身数据内容
            List<Map<String, Object>> rows = table.getRows();

            List<JSONObject> tableDatas = intermediateDataItem.getPageData();
            for (JSONObject tableData : tableDatas) {
                Map<String, Object> row = new HashMap<>(columns.size() + 2);
                List<TableColumnConfig> tableColumnConfigs = new ArrayList<>();
                for (UiBotTableColumn column : columns) {
                    row.put(column.getSchema(), column.getValueForDisplay(tableData, true));
                    /**
                     * 单元格配置
                     */
                    tableColumnConfigs.add(TableColumnConfig.create(column, executeContext));
                }
                row.put("columnConfig", tableColumnConfigs);
                rows.add(row);
            }
        } else {
            List<TableColumnDefinition> columnDefinitionList = tableRenderSetting.getColumns();
            if (CollectionUtils.isEmpty(columnDefinitionList)) {
                return table;
            }
            // 将所有列拆解，方便从原始pageData中取数据
            List<UiBotTableColumn> decomposedColumnList = TableColumnDefinition.decomposeTableColumnDefinitions(columnDefinitionList);

            // 表头
            List<TableHeaderDataSet> tableHeaderDataSetList = TableHeaderDataSet.getCompoundTableHeaderDataSetList(
                    columnDefinitionList, needFilterAndSort);
            tableHeader.setHeaderDataset(tableHeaderDataSetList);

            List<JSONObject> tableDatas = intermediateDataItem.getPageData();
            // 表身数据内容
            List<Map<String, Object>> rows = table.getRows();
            // 表身数据中每行的单元格配置
            List<TableColumnConfig> tableColumnConfigs = TableColumnConfig.getTableColumnConfigs(
                    columnDefinitionList, decomposedColumnList, tableDatas, executeContext);

            for (JSONObject tableData : tableDatas) {
                Map<String, Object> row = new HashMap<>(decomposedColumnList.size() + 2);
                for (UiBotTableColumn column : decomposedColumnList) {
                    row.put(column.getSchema(), column.getValueForDisplay(tableData, true));
                }
                row.put("columnConfig", tableColumnConfigs);
                rows.add(row);
            }
        }


        // 表数据的隐藏条件
        if (useCollapse) {
            TableHiddenConfig tableHiddenConfig = new TableHiddenConfig();
            tableHiddenConfig.setHiddenExpandContent(hiddenHintContent);
            table.setHiddenConfig(tableHiddenConfig);
        }

        return table;
    }

    /**
     * 设计态设计的table 结构
     */
    private TableDesignContent designContent;

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.resetCmptMultipleDataSourceData(cmptContext, executeContext, Optional.ofNullable(this.designContent).map(TableDesignContent::getData).map(Card.DesignerRawCard::getDataSource).orElse(null), data);
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        List<Map<String, Object>> dataList;
        if (data.containsKey(UiBotDesignerRenderService.LIST_MARKER)) {
            // 任务详情页渲染
            if (ZtbViewList.isChildNode(mobilePath, schema)) {
                data.remove(UiBotDesignerRenderService.LIST_MARKER);
                // 详情页，列表是数据源下的一个节点
                mobilePageRawData.setRawMap(data);
                dataList = (List<Map<String, Object>>) UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
            } else {
                // 表示整体数据是数组 -- 不可传入rawMap数据，否则会影响非任务详情页提交按钮中action的rawdata中data数据
                mobilePageRawData.setRawMap(null);
                // 表示整体数据是数组
                dataList = (List<Map<String, Object>>) UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
            }
        } else {
            // 非任务详情页渲染
            mobilePageRawData.setRawMap(data);
            // 表示对象中schema值是是数组
            dataList = (List<Map<String, Object>>) UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema);
        }

        this.name = BooleanUtils.isTrue(this.designContent.getNameVisible()) ? this.name : "";
        this.columnFreeze = 0;
        if (this.designContent.getRowIndex()) {
            addTableHeader(dataList,executeContext.getLocale());
        }

        this.tableHeader = buildTableHeader(this.designContent.getData().getContent(), false);
        this.rows = buildTableRows(this.designContent.getData().getContent(), dataList);
        this.defaultLandscape = false;
        this.isLandscape = BooleanUtils.isTrue(designContent.getIsLandscape());
        // 需要用到上面的参数，故放在最后
        this.hiddenConfig = this.buildTableHiddenConfig(this.designContent, dataList);
    }

    public void addTableHeader(List<Map<String, Object>> dataList,String locale){
        //显示排序号
        List<Card.DesignerRawCard.Content> content = designContent.getData().getContent();
        //增加表头
        if (!CollectionUtils.isEmpty(content)) {
            Card.DesignerRawCard.Content headContent = new Card.DesignerRawCard.Content();
            headContent.setLabel(localeService.getLanguageValue(locale, "序号"));
            headContent.setSchema(PcUiBotConstants.MOBILE_TABLE_SEQ);
            content.add(0, headContent);
        }
        //增加表数据
        AtomicInteger index = new AtomicInteger(0);
        if (!CollectionUtils.isEmpty(dataList)) {
            dataList.stream().forEach(map -> map.put(PcUiBotConstants.MOBILE_TABLE_SEQ, index.getAndIncrement()));
        }
    }

    public static List<Map<String, Object>> buildTableRows(List<Card.DesignerRawCard.Content> contents, List<Map<String, Object>> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return new ArrayList<>();
        }
        return dataList.stream().map(data -> {
            // 表身数据内容
            Map<String, Object> row = new HashMap<>();
            // 表身数据中每行的单元格配置
            List<TableColumnConfig> tableColumnConfigs = new ArrayList<>();
            if (!CollectionUtils.isEmpty(contents)) {
                contents.forEach(content -> {
                    // 获取行数据显示值
                    row.put(content.getSchema(), Card.getDisplayValue(content, StringUtil.valueOf(data.get(content.getSchema()))));
                    if (!CollectionUtils.isEmpty(content.getSubContent())) {
                        content.getSubContent().forEach(subContent -> row.put(subContent.getSchema(), Card.getDisplayValue(subContent, StringUtil.valueOf(data.get(subContent.getSchema())))));
                    }

                    // 行数据行的单元格配置
                    TableColumnConfig tableColumnConfig = new TableColumnConfig();
                    tableColumnConfig.setCanDrillDown(false);
                    tableColumnConfig.setColumnId(content.getSchema());
                    tableColumnConfig.setAction(null);
                    // 复合列的子列信息
                    List<TableCompoundColumn> tableCompoundColumns = buildTableRowCompoundCols(content);
                    tableColumnConfig.setFontColor(CollectionUtils.isEmpty(tableCompoundColumns) ? TableColumnColorEnum.NORMAL.getColor() : null);
                    tableColumnConfig.setCompoundCols(tableCompoundColumns);
                    tableColumnConfigs.add(tableColumnConfig);

                });
            }
            row.put("columnConfig", tableColumnConfigs);
            return row;
        }).collect(Collectors.toList());
    }

    private static List<TableCompoundColumn> buildTableRowCompoundCols(Card.DesignerRawCard.Content content) {
        // 复合列的子列信息
        List<TableCompoundColumn> compoundColumns = new ArrayList<>();
        if (CollectionUtils.isEmpty(content.getSubContent())) {
            return compoundColumns;
        }
        TableCompoundColumn compoundColumn = new TableCompoundColumn();
        compoundColumn.setColumnId(content.getSchema());
        compoundColumn.setFontColor(TableColumnColorEnum.NORMAL.getColor());
        compoundColumns.add(compoundColumn);
        // 组合列
        content.getSubContent().forEach(subContent -> {
            TableCompoundColumn column = new TableCompoundColumn();
            column.setColumnId(subContent.getSchema());
            column.setFontColor("#FFFFFF");
            compoundColumns.add(column);
        });
        return compoundColumns;
    }

    public static TableHeader buildTableHeader(List<Card.DesignerRawCard.Content> contents, boolean tableFixed) {
        TableHeader tableHeader = new TableHeader();
        tableHeader.setTableFixed(tableFixed);
        tableHeader.setHeaderDataset(buildTableHeaderDataset(contents));
        return tableHeader;
    }

    private static List<TableHeaderDataSet> buildTableHeaderDataset(List<Card.DesignerRawCard.Content> contents) {
        if (CollectionUtils.isEmpty(contents)) {
            return new ArrayList<>();
        }
        return contents.stream().map(content -> {
            TableHeaderDataSet tableHeaderData = new TableHeaderDataSet()
                    .setId(content.getSchema())
                    .setContent(content.getLabel())
                    .setDataType(content.getData_type())
                    .setCanSort(content.getCanSort())
                    .setCanFilter(content.getCanFilter())
                    .setFilterStyle(TableHeaderFilterStyleEnum.FILTER_WITH_ENTRY.getValue())
                    .setHAlignType(TableHeaderHAlignTypeEnum.RIGHT.getValue())
                    .setWidth(content.getWidth());
            if (CollectionUtils.isEmpty(content.getSubContent())) {
                // 复合列（组合列）的情况下，统一设置为字符串，默认左对齐，无排序，无过滤
                tableHeaderData.forceSetCompoundMode();
            }
            return tableHeaderData;
        }).collect(Collectors.toList());
    }

    private TableHiddenConfig buildTableHiddenConfig(TableDesignContent designContent, List<Map<String, Object>> dataList) {
        // 加载更多方式 1：点击下方加载更多；2：点击新页加载更多
        Integer loadType = designContent.getLoadType();
        if (Integer.valueOf(1).equals(loadType)) {
            // 1：点击下方加载更多
            TableHiddenConfig tableHiddenConfig = new TableHiddenConfig();
            tableHiddenConfig.setHiddenCount(designContent.getPageSize());
            tableHiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey(AppRequestContext.getContextEntity().getLocale(), "查看更多"));
            tableHiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByKey(AppRequestContext.getContextEntity().getLocale(), "收起"));
            return tableHiddenConfig;
        } else if (Integer.valueOf(2).equals(loadType)) {
            // 2：点击新页加载更多
            TableHiddenConfig tableHiddenConfig = new TableHiddenConfig();
            tableHiddenConfig.setHiddenCount(designContent.getPageSize());
            tableHiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey(AppRequestContext.getContextEntity().getLocale(), "查看更多"));
            tableHiddenConfig.setAction(this.buildAction(designContent, dataList));
            return tableHiddenConfig;
        } else {
            // 其它默认
            TableHiddenConfig tableHiddenConfig = new TableHiddenConfig();
            tableHiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey(AppRequestContext.getContextEntity().getLocale(), "查看更多"));
            tableHiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByKey(AppRequestContext.getContextEntity().getLocale(), "收起"));
            return tableHiddenConfig;
        }
    }

    private Action<CardListToTableRawData> buildAction(TableDesignContent designContent, List<Map<String, Object>> dataList) {
        Action<CardListToTableRawData> action = new Action<>();
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_CARDLIST_CONVERT_TABLE_PAGE.name());
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        CardListToTableRawData rawData = new CardListToTableRawData();
        action.setRawData(rawData);

        rawData.setDataList(dataList);
        Card.DesignerRawCard.TableConfig tableConfig = new Card.DesignerRawCard.TableConfig();
        tableConfig.setName(this.name);
        tableConfig.setColumnFreeze(this.columnFreeze);
        tableConfig.setTableFixed(false);
        tableConfig.setContent(designContent.getData().getContent());
        tableConfig.setDefaultLandscape(this.defaultLandscape);
        tableConfig.setIsLandscape(this.isLandscape);
        rawData.setTableConfig(tableConfig);

        return action;
    }
}
