package com.digiwin.mobile.mobileuibot.core.component.table;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.table.AgileDataTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.table.TableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 表格复合列对象
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TableCompoundColumn implements Serializable {
    private static final long serialVersionUID = 5398682004974673467L;

    private String columnId;

    /**
     * 字体颜色。使用十六进制，如：#5470c6
     */
    private String fontColor;
    /**
     * 列内容水平对齐方式（默认左对齐）
     *
     * @see TableHeaderHAlignTypeEnum
     */
    @JsonProperty(value = "hAlignType")
    @JSONField(name = "hAlignType")
    private String hAlignType = TableHeaderHAlignTypeEnum.LEFT.getValue();


    public void buildFontColor(TableColumnConfig tableColumnConfig, JSONArray operations) {
        if (AgileDataTableColumn.canDrillDown(operations)) {
            tableColumnConfig.setCanDrillDown(true);
            /**
             * 下钻的颜色
             */
            tableColumnConfig.setFontColor(TableColumnColorEnum.CAN_DRILL_DOWN.getColor());
        } else if (AgileDataTableColumn.isHighlight(operations)) {
            /**
             * 强调的颜色
             */
            tableColumnConfig.setFontColor(TableColumnColorEnum.HIGHLIGHT.getColor());
        } else {
            tableColumnConfig.setCanDrillDown(false);
        }
    }

    /**
     * 从中间态DSL数据中的列定义获取移动端表格行复合列的信息
     *
     * @return
     */
    public static List<TableCompoundColumn> getCompoundColumns(TableColumnDefinition columnDefinition) {
        if (!columnDefinition.preferCompoundMode()) {
            return Collections.emptyList();
        }

        List<UiBotTableColumn> decomposedColumns = TableColumnDefinition.decomposeTableColumn(columnDefinition.getColumns());
        List<TableCompoundColumn> compoundColumns = new ArrayList<>(decomposedColumns.size());
        for (int i = 0; i < decomposedColumns.size(); i++) {
            UiBotTableColumn tableColumn = decomposedColumns.get(i);
            TableCompoundColumn compoundColumn = new TableCompoundColumn();
            compoundColumn.setColumnId(tableColumn.getSchema());
            compoundColumn.setFontColor(TableCompoundColumnColorPalette.getColorFromColumnPalette(i));

            compoundColumns.add(compoundColumn);
        }

        return compoundColumns;
    }
}