package com.digiwin.mobile.mobileuibot.core.component.table;

import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>功能描述：设计态设计的table 结构</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TableDesignContent.java
 * @Author: wangjwc
 * @Date: created at 2024/6/3 14:18
 */
@Data
public class TableDesignContent implements Serializable {
    private static final long serialVersionUID = 8006137916022018987L;

    /**
     * 表名是否显示，true：显示，false：隐藏
     */
    private Boolean nameVisible;
    /**
     * 加载更多方式
     * 1：点击下方加载更多
     * 2：点击新页加载更多
     */
    private Integer loadType;
    /**
     * 分页大小
     */
    private Integer pageSize;
    /**
     * 是否支持横竖屏
     */
    private Boolean isLandscape;

    /**
     * 是否显示序号，默认不显示
     */
    private Boolean rowIndex = false;

    /**
     * Table 配置
     */
    private Card.DesignerRawCard data;
}
