package com.digiwin.mobile.mobileuibot.core.component.table;

import java.util.Objects;

/**
 * <p>功能描述：表头筛选样式枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TableHeaderFilterStyleEnum
 * @Author: zaregoto
 * @Date: 2023/12/21 10:59
 */
public enum TableHeaderFilterStyleEnum {
    /**
     * 输入型筛选
     */
    FILTER_WITH_ENTRY("1"),

    /**
     * 选择型筛选
     */
    FILTER_WITH_SELECT("2"),

    /**
     * 输入型+选择型筛选
     */
    FILTER_WITH_ENTRY_AND_SELECT("3"),

    ;

    private final String value;

    TableHeaderFilterStyleEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static TableHeaderFilterStyleEnum getEnumByValue(String value) {
        for (TableHeaderFilterStyleEnum testedEnum : TableHeaderFilterStyleEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
