package com.digiwin.mobile.mobileuibot.core.component.table;

import java.util.Objects;

/**
 * <p>功能描述：列内容水平对齐方式</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TableHeaderHAlignTypeEnum
 * @Author: zaregoto
 * @Date: 2023/12/21 16:45
 */
public enum TableHeaderHAlignTypeEnum {
    /**
     * 左对齐
     */
    LEFT("1"),

    /**
     * 右对齐
     */
    RIGHT("2"),

    ;

    private final String value;

    TableHeaderHAlignTypeEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static TableHeaderHAlignTypeEnum getEnumByValue(String value) {
        for (TableHeaderHAlignTypeEnum testedEnum : TableHeaderHAlignTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
