package com.digiwin.mobile.mobileuibot.core.component.table;

import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wuyang
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class TableHiddenConfig implements Serializable {
    private static final long serialVersionUID = 1611393591294336594L;

    /**
     * 默认表格触发隐藏的行数
     */
    public static final Integer DEFAULT_USE_COLLAPSE_HIDDEN_COUNT = 6;

    /**
     * 触发隐藏的表格行数
     */
    private Integer hiddenCount = DEFAULT_USE_COLLAPSE_HIDDEN_COUNT;
    /**
     * 触发隐藏时，隐藏的提示语
     */
    private String hiddenExpandContent;
    /**
     * 触发隐藏时，收起的提示语
     */
    private String hiddenUnexpandContent;

    /**
     * 点击查看更多事件
     */
    private Action action;
}
