package com.digiwin.mobile.mobileuibot.core.component.title;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;

import java.io.Serializable;

/**
 * <p>功能描述：标题内容</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TitleContent
 * @Author: Zaregoto
 * @Date: 2021/6/14 15:43
 */
public class TitleContent extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = -6203593244960524856L;
    public static final String COMPONENT_TYPE = "TITLE_CONTENT";

    /**
     * 标题
     */
    private String text;

    /**
     * 页面描述
     */
    private PageDesc desc;

    public TitleContent() {
    }

    public TitleContent(String text, PageDesc desc) {
        this.text = text;
        this.desc = desc;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public PageDesc getDesc() {
        return desc;
    }

    public void setDesc(PageDesc desc) {
        this.desc = desc;
    }

    @Override public String returnComponentType() {
        return TitleContent.COMPONENT_TYPE;
    }
}
