package com.digiwin.mobile.mobileuibot.core.component.title.articletitle;

import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailFixedNameEnum;
import com.digiwin.mobile.mobileuibot.search.SearchItemDetailStyleEnum;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：文章标题组件数据模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ArticleTitle
 * @Author: Liux
 * @Date: 2022年6月7日 13点59分
 */
public class ArticleTitle extends BaseMobileComponent implements Serializable {

    private static final long serialVersionUID = -5953855850113475876L;
    public static final String COMPONENT_TYPE = "ARTICLE_TITLE";

    //次要内容。1-标题弱化，呈灰色
    private BaseArticleContent minorContent;
    //次要内容样式
    private Integer minorContentStyle;
    //副标题
    private String subTitle;
    //主标题
    private String title;
    //标题的样式类型。1-标题弱化，呈灰色， 2-标题正常，呈黑色， 3-标题黑色加粗，字号30px
    private Integer titleStyleType;

    @Override
    public String returnComponentType() {
        return ArticleTitle.COMPONENT_TYPE;
    }

    public ArticleTitle() {
    }

    public static ArticleTitle create(String locale, String iamUserToken, Map<String, Object> detailInfo) {
        List<Map<String, Object>> knowledgeTagList = (List<Map<String, Object>>) detailInfo.get("knowledge_tag");
        String tagName = "";
        if (knowledgeTagList.size() > 0) {
            for (int i = 0; i < knowledgeTagList.size(); i++) {
                Map<String, Object> knowledgeTag = knowledgeTagList.get(i);
                tagName += i == knowledgeTagList.size() - 1 ? knowledgeTag.get("tag_name") : knowledgeTag.get("tag_name") + "，";
            }
        }
        BaseArticleContent minorContent = new BaseArticleContent();
        minorContent.setLabel(tagName);
        minorContent.setReadNum((Integer) detailInfo.get("doc_view_number"));
        minorContent.setReadNumName(
                LocaleUtil.getMobileTextByKey(locale, SearchItemDetailFixedNameEnum.READ_NUM_NAME.getValue())
        );
        minorContent.setAuthor(String.valueOf(detailInfo.get("create_name")));
        minorContent.setCreateTime(String.valueOf(detailInfo.get("create_time")));

        ArticleTitle articleTitle = new ArticleTitle();
        articleTitle.setTitle(String.valueOf(detailInfo.get("knowledge_name")));
        articleTitle.setTitleStyleType(SearchItemDetailStyleEnum.TITLE_STYLE_TYPE_THREE.getValue());
        articleTitle.setMinorContentStyle(SearchItemDetailStyleEnum.MINOR_CONTENT_STYLE_ONE.getValue());
        articleTitle.setMinorContent(minorContent);

        return articleTitle;
    }


    public BaseArticleContent getMinorContent() {
        return minorContent;
    }

    public void setMinorContent(BaseArticleContent minorContent) {
        this.minorContent = minorContent;
    }

    public Integer getMinorContentStyle() {
        return minorContentStyle;
    }

    public void setMinorContentStyle(Integer minorContentStyle) {
        this.minorContentStyle = minorContentStyle;
    }

    public String getSubTitle() {
        return subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getTitleStyleType() {
        return titleStyleType;
    }

    public void setTitleStyleType(Integer titleStyleType) {
        this.titleStyleType = titleStyleType;
    }
}
