package com.digiwin.mobile.mobileuibot.core.component.title.portal;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.title.teamtitle.TeamTitleDetail;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 *V2门户标题组件
 */
@Data
public class PortalTitle extends BaseMobileComponent implements Serializable {

    public static final String COMPONENT_TYPE = "TITLE_TILE";
    private static final long serialVersionUID = 6491971829998038208L;

    /**
     * 背景色
     */
    private String backgroundColor;

    /**
     *主标题
     */
    private String title;

    /**
     *副标题
     */
    private String subTitle;

    /**
     *右标题
     */
    private String rightTitle;


    /**
     *主标题样式
     */
    private TitleColor titleTextStyle;

    /**
     *副标题文字样式
     */
    private TitleColor subTitleTextStyle;

    /**
     *显示链接（0：不展示；1：展示）
     */
    private Integer linkFlag;

    /**
     *右侧标题文字样式
     */
    private TitleColor rightTitleTextStyle;


    /**
     *标题组件头部样式
     */
    private TitleStyle leaderStyle;

    /**
     * ActionEvent，移动端事件类
     */
    private Action action;


    @Override
    public String returnComponentType() {
        return PortalTitle.COMPONENT_TYPE;
    }
}
