package com.digiwin.mobile.mobileuibot.core.component.title.titlebody;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: BaseTitleBodyBuilder
 * @Author: Zaregoto
 * @Date: 2021/8/18 20:44
 */
@Slf4j
@Component("baseTitleBodyBuilder")
public class BaseTitleBodyBuilder implements TitleBodyBuilder {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;

    /**
     * 移动端layout与PC端layout的对应关系
     * key-app端
     * value-pc端
     */
    private volatile Map<String, String> componentMap;

    public BaseTitleBodyBuilder() {
        this.componentMap = new HashMap<>();
        componentMap.put(this.getMobileComponentType(), "ACTIVITY_TITLE");
    }

    @Override
    public TitleBody build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                           Class clazz, Object... args) {
        String locale = apiRequest.getLocale();
        Optional<UiBotLayout> optLayout = pcUiBotModel.getLayout().stream().filter(
                layout -> "ACTIVITY_TITLE".equals(layout.getType())
        ).findFirst();
        if (!optLayout.isPresent()) {
            return TitleBody.createEmpty();
        }

        UiBotLayout layout = optLayout.get();
        String schema = layout.getSchema();
        Map<String, Object> data = (Map<String, Object>) pcUiBotModel.getPageData().get(schema);
        Assert.notNull(data, "pagedata." + schema + " cannot be null");

        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = (DigiwinAtmcBacklogDetail) args[0];
        Map<String, Object> uiBotActivityData =
                (Map<String, Object>) pcUiBotModel.getPageData().get("uiBot__activity");

        // 只有是合并任务卡且planEndTimeMin和planEndTimeMax不一致才展示时间区间，否则展示时间点
        String planEndTimeMin = MapUtils.getString(uiBotActivityData, "planEndTimeMin");
        String planEndTimeMax = MapUtils.getString(uiBotActivityData, "planEndTimeMax");
        String endMonthDate;
        if (BooleanUtils.isTrue(digiwinAtmcBacklogDetail.getMerge()) && !Objects.equals(planEndTimeMin, planEndTimeMax)) {
            endMonthDate = DateTimeUtil.getMonthDateOfTime(planEndTimeMin) + "-" + DateTimeUtil.getMonthDateOfTime(planEndTimeMax);
        } else {
            endMonthDate = DateTimeUtil.getMonthDateOfTime(MapUtils.getString(uiBotActivityData, "endTime"));
        }

        String systemTip = LocaleUtil.getMobileTextByKey(locale, "需完成");
        String taskName = (String) uiBotActivityData.get("name");
        String approvalState = digiwinAtmcBacklogDetail.getApprovalState();

        String overdueDate = Optional.ofNullable(digiwinAtmcBacklogDetail.getOverdueDate()).orElse(
                Optional.ofNullable((String) data.get("overdueDate")).orElse("")
        );
        String remainTime = Optional.ofNullable(digiwinAtmcBacklogDetail.getRemainTime()).orElse(
                Optional.ofNullable((String) data.get("remainTime")).orElse("")
        );
        boolean isOverdue = !overdueDate.isEmpty() && remainTime.isEmpty();

        List<Tag> tags = new ArrayList<>();
        if (StringUtils.hasLength(approvalState)) {
            Tag approvalStateTag = Tag.createApprovalStateTag(approvalState);
            tags.add(approvalStateTag);
        }

        Tag timeHintTag =
                isOverdue ?
                        Tag.createWarningTag(
                                new StringBuilder(this.localeService.getLanguageValue(locale, "逾期"))
                                        .append(overdueDate).toString()
                        )
                        :
                        Tag.createPromptTag(
                                new StringBuilder(this.localeService.getLanguageValue(locale, "倒计时"))
                                        .append(remainTime).toString()
                        );
        tags.add(timeHintTag);

        return TitleBody.create(endMonthDate + systemTip + " " + taskName,
                this.pageDescBuilderFactory.get(TaskStringUtil.TASK_TYPE_BIZ_REPORT)
                        .build(apiRequest, pageSetting, pcUiBotModel, PageDesc.class, args),
                timeHintTag, tags);
    }
}
