package com.digiwin.mobile.mobileuibot.core.component.title.titlebody;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.card.Postmark;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContent;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleContent;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleLabelPositionEnum;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.project.common.ProjectTypeUtil;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcEnginePanelInfo;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import lombok.Data;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>功能描述：正文内容标题组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TitleBody
 * @Author: Zaregoto
 * @Date: 2021/6/14 15:37
 */
@Data
public class TitleBody extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = -4820931670834814366L;
    public static final String COMPONENT_TYPE = "TITLE_BODY";

    private TitleContent content;
    @Deprecated
    private Tag tag;
    private List<Tag> tags;
    private Postmark postmark;

    /**
     * label相对于标题的位置，默认为标题的下边
     */
    private Integer labelPosition = TitleLabelPositionEnum.DOWN_TO_TITLE.getPosition();

    public TitleBody() {
    }

    /**
     * 旧版使用的tag属性，不再使用
     *
     * @param titleText
     * @param pageDesc
     * @param tag
     * @return
     */
    @Deprecated
    public static TitleBody create(String titleText, PageDesc pageDesc, Tag tag) {
        TitleBody titleBody = new TitleBody();
        titleBody.setContent(new TitleContent(titleText, pageDesc));
        titleBody.setTag(tag);

        return titleBody;
    }

    /**
     * 为兼容前端旧版的tag属性
     *
     * @param titleText
     * @param pageDesc
     * @param tag
     * @param tags
     * @return
     */
    public static TitleBody create(String titleText, PageDesc pageDesc, Tag tag, List<Tag> tags) {
        TitleBody titleBody = new TitleBody();
        titleBody.setContent(new TitleContent(titleText, pageDesc));
        titleBody.setTag(tag);
        titleBody.setTags(tags);

        return titleBody;
    }

    public static TitleBody create(String titleText, PageDesc pageDesc, Tag tag, List<Tag> tags, Postmark postmark) {
        TitleBody titleBody = new TitleBody();
        titleBody.setContent(new TitleContent(titleText, pageDesc));
        titleBody.setTag(tag);
        titleBody.setTags(tags);
        if (postmark != null) {
            titleBody.setPostmark(postmark);
        }

        return titleBody;
    }

    public static TitleBody create(String titleText, PageDesc pageDesc, List<Tag> tags) {
        TitleBody titleBody = new TitleBody();
        titleBody.setContent(new TitleContent(titleText, pageDesc));
        titleBody.setTags(tags);

        return titleBody;
    }

    public static TitleBody createEmpty() {
        return new TitleBody();
    }

    public static TitleBody create(String locale, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail) {
        Map<String, Object> data = new HashMap<>(1);
        data.put("taskName", digiwinAtmcBacklogDetail.getName());
        return create(locale, digiwinAtmcBacklogDetail, data);
    }

    public static TitleBody createApc(String locale, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail,
                                      UiBotLayout findLayout, Map<String, Object> pageData) {
        Map<String, Object> data = new HashMap<>(1);
        data.put("taskName", digiwinAtmcBacklogDetail.getName());
        TitleBody titleBody = create(locale, digiwinAtmcBacklogDetail, data);
        List<PageDescContent> content = titleBody.getContent().getDesc().getContent();
        List<UiBotLayout> uiBotLayouts = findLayout.getGroup();
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            PageDescContent pageDescContent = new PageDescContent();
            if (ObjectUtils.isEmpty(pageData)) {
                pageDescContent.setText(uiBotLayout.getHeaderName());
            } else {
                String value = "";
                if ("production_qty".equals(uiBotLayout.getSchema())) {
                    Double qty = 0.0;
                    DecimalFormat df = new DecimalFormat("0.######");
                    if (pageData.get(uiBotLayout.getSchema()) != null) {
                        if (pageData.get(uiBotLayout.getSchema()) instanceof Double) {
                            qty = (Double) pageData.get(uiBotLayout.getSchema());
                        } else {
                            qty = ((Integer) pageData.get(uiBotLayout.getSchema())).doubleValue();
                        }
                        value = df.format(qty);
                    }else{
                        value = "-";
                    }
                } else {
                    value = ModuleUtils.emptyValueToHyphen(pageData.get(uiBotLayout.getSchema()));
                }
                pageDescContent.setText(uiBotLayout.getHeaderName() + ": " + value);
            }
            content.add(pageDescContent);
        }
        return titleBody;
    }

    public static TitleBody createApc(DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, UiBotModel pcUiBotModel, String locale) {
        UiBotLayout findLayout = UiBotModel.getApprovalDesriptionLayout(pcUiBotModel.getLayout());
        Map<String, Object> titleData = (Map<String, Object>) pcUiBotModel.getPageData().get(findLayout.getSchema());
        TitleBody titleBody = TitleBody.createApc(locale, digiwinAtmcBacklogDetail, findLayout, titleData);
        return titleBody;
    }


    public static TitleBody create(String locale, DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail, Map<String, Object> data) {
        TitleBody titleBody = new TitleBody();
        TitleContent titleContent = new TitleContent();

        String planEndTimeMin = digiwinAtmcBacklogDetail.getPlanEndTimeMin();
        String planEndTimeMax = digiwinAtmcBacklogDetail.getPlanEndTimeMax();
        String endMonthDate;
        // 只有是合并任务卡且planEndTimeMin和planEndTimeMax不一致才展示时间区间，否则展示时间点
        if (BooleanUtils.isTrue(digiwinAtmcBacklogDetail.getMerge()) && !Objects.equals(planEndTimeMin, planEndTimeMax)) {
            endMonthDate = DateTimeUtil.getMonthDateOfTime(planEndTimeMin) + "-" + DateTimeUtil.getMonthDateOfTime(planEndTimeMax);
        } else {
            endMonthDate = DateTimeUtil.getMonthDateOfTime(digiwinAtmcBacklogDetail.getEndTime());
        }
        String systemTip = LocaleUtil.getMobileTextByKey(locale, "需完成");
        String taskName = (String) data.get("taskName");
        titleContent.setText(endMonthDate + systemTip + " " + taskName);
        PageDesc pageDesc = new PageDesc();
        pageDesc.setTitle(digiwinAtmcBacklogDetail.getName());
        pageDesc.addContent(0xe673, digiwinAtmcBacklogDetail.getTaskName(), PageDescContentTypeEnum.NORMAL.getValue());
        titleContent.setDesc(pageDesc);
        titleBody.setContent(titleContent);

        List<Tag> tags = new ArrayList<>(1);
        Boolean isOverdue = false;
        if (DateTimeUtil.parseUseDefaultPattern(digiwinAtmcBacklogDetail.getBackLogEndTime()).isAfter(LocalDateTime.now())) {
            isOverdue = true;
        }
        Tag timeHintTag =
                isOverdue ?
                        Tag.createWarningTag(
                                TaskStringUtil.getTaskTimeHintText(locale, digiwinAtmcBacklogDetail.getBackLogEndTime()))
                        :
                        Tag.createPromptTag(
                                TaskStringUtil.getTaskTimeHintText(locale, digiwinAtmcBacklogDetail.getBackLogEndTime()));
        tags.add(timeHintTag);
        titleBody.setTags(tags);
        return titleBody;
    }

    public static TitleBody create(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                   PccProjectInfo projectInfo, DigiwinAtmcPanel atmcPanel, PageDescBuilderFactory pageDescBuilderFactory) {
        TitleBody titleBody = new TitleBody();

        TitleContent titleContent = new TitleContent(projectInfo.getProjectName(),
                pageDescBuilderFactory.get(ProjectTypeUtil.PCC_OLD_PROJECT_TYPE)
                        .build(apiRequest, pageSetting, pcUiBotModel, PageDesc.class, projectInfo, atmcPanel));
        titleBody.setContent(titleContent);

        List<Tag> tags = new ArrayList<>(2);
        Tag propertyTag = Tag.createWriteBgdBlueTextTag(ProjectStringUtil.getProjectCCPropertyString(apiRequest.getLocale(), projectInfo.getProjectProperty()), new Action());
        tags.add(propertyTag);
        Tag statusTag = Tag.createBlueBgdWriteTextStateTag(ProjectStringUtil.getProjectCCStatusString(apiRequest.getLocale(), projectInfo.getProjectStatus()));
        tags.add(statusTag);

        titleBody.setTags(tags);
        return titleBody;
    }

    public static TitleBody createPccNotStarted(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                                                PccProjectInfo projectInfo, DigiwinAtmcEnginePanelInfo atmcEnginePanelInfo, PageDescBuilderFactory pageDescBuilderFactory) {
        TitleBody titleBody = new TitleBody();

        TitleContent titleContent = new TitleContent(projectInfo.getProjectName(),
                pageDescBuilderFactory.get(ProjectTypeUtil.PCC_OLD_PROJECT_TYPE)
                        .build(apiRequest, pageSetting, pcUiBotModel, PageDesc.class, projectInfo, atmcEnginePanelInfo));
        titleBody.setContent(titleContent);

        List<Tag> tags = new ArrayList<>(2);
        Tag propertyTag = Tag.createWriteBgdBlueTextTag(ProjectStringUtil.getProjectCCPropertyString(apiRequest.getLocale(), projectInfo.getProjectProperty()), new Action());
        tags.add(propertyTag);
        Tag statusTag = Tag.createBlueBgdWriteTextStateTag(ProjectStringUtil.getProjectCCStatusString(apiRequest.getLocale(), projectInfo.getProjectStatus()));
        tags.add(statusTag);

        titleBody.setTags(tags);
        return titleBody;
    }

    public TitleContent getContent() {
        return content;
    }

    public void setContent(TitleContent content) {
        this.content = content;
    }

    @Deprecated
    public Tag getTag() {
        return tag;
    }

    @Deprecated
    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public Integer getLabelPosition() {
        return labelPosition;
    }

    public void setLabelPosition(Integer labelPosition) {
        this.labelPosition = labelPosition;
    }

    public List<Tag> getTags() {
        return tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    @Override
    public String returnComponentType() {
        return TitleBody.COMPONENT_TYPE;
    }
}