package com.digiwin.mobile.mobileuibot.core.component.title.titledesc;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.basic.LabelTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescBuilderFactory;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleContent;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.project.common.ProjectTypeUtil;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcPanel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TitleDescProjectCCBuilder
 * @Author: Zaregoto
 * @Date: 2021/7/5 16:57
 */
@Component("titleDescProjectCCBuilder")
public class TitleDescProjectCCBuilder implements TitleDescBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TitleDescProjectCCBuilder.class);

    @Autowired
    private PageDescBuilderFactory pageDescBuilderFactory;

    @Override
    public TitleDesc build(ApiRequest apiRequest, PageSetting pageSetting, UiBotModel pcUiBotModel,
                           Class<TitleDesc> clazz, Object... args) {
        String locale = apiRequest.getLocale();

        Assert.notNull(args, "args must not null");
        Assert.notEmpty(args, "args must not empty");
        Assert.isInstanceOf(PccProjectInfo.class, args[0],
                "args[0] must be instance of DigiwinAtdmProjectInfo");
        Assert.isInstanceOf(DigiwinAtmcPanel.class, args[1],
                "args[1] must be instance of DigiwinAtmcPanel");

        PccProjectInfo projectInfo = (PccProjectInfo) args[0];
        DigiwinAtmcPanel atmcPanel = (DigiwinAtmcPanel) args[1];
        TitleDesc titleDesc = new TitleDesc();

        TitleContent titleContent = new TitleContent(projectInfo.getProjectName(),
                this.pageDescBuilderFactory.get(ProjectTypeUtil.PCC_OLD_PROJECT_TYPE)
                        .build(apiRequest, pageSetting, pcUiBotModel, PageDesc.class, projectInfo, atmcPanel));
        titleDesc.setContent(titleContent);

        Label projectPropertyLabel = Label.create(
                ProjectStringUtil.getProjectCCPropertyString(locale, projectInfo.getProjectProperty()), LabelTypeEnum.STRESS.getType());
        Label projectStatusLabel = Label.create(
                ProjectStringUtil.getProjectCCStatusString(locale, projectInfo.getProjectStatus()), LabelTypeEnum.NORMAL.getType());
        titleDesc.addLabel(projectPropertyLabel);
        titleDesc.addLabel(projectStatusLabel);

        return titleDesc;
    }
}
