package com.digiwin.mobile.mobileuibot.core.component.webview;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：Webview组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: Webview
 * @Author: Zaregoto
 * @Date: 2021/9/7 21:06
 */
@Data
public class Webview extends BaseMobileComponent implements Serializable {
    private static final long serialVersionUID = -5538834550678950525L;
    public static final String COMPONENT_TYPE = "WEBVIEW";

    @Override
    public String returnComponentType() {
        return Webview.COMPONENT_TYPE;
    }

    /**
     * 尺寸
     *
     * @see WebviewSizeModeEnum
     */
    private Integer sizeMode;
    private String title;
    private String url;
    private List<BottomButtonDigiwinAthena> buttonList;
    private WebviewButtonTipConfig buttonTipConfig;

    /**
     * 宽度样式
     *
     * @see WebviewWidthModeEnum
     */
    private Integer widthMode;
    /**
     * 宽高比，高度计算方式：height=width/aspectRatio
     */
    private Double aspectRatio;
    /**
     * 竖直方向是否可以滚动
     */
    private Boolean verticalScroll = false;


    public Webview() {
        this.buttonList = new ArrayList<>(1);
    }

    @Override
    public void initSetting(String locale) {
        super.initSetting(locale);
        if (null != this.buttonTipConfig) {
            String configedTipConfig = this.buttonTipConfig.getText();
            this.buttonTipConfig.setText(LocaleUtil.getMobileTextByDatabaseKey(locale, configedTipConfig));
        }
    }

    public BottomButtonDigiwinAthena createLeftSlipOpenWindowButton() {
        BottomButtonDigiwinAthena buttonDigiwinAthena = new BottomButtonDigiwinAthena();
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
        buttonDigiwinAthena.setAction(action);
        //放大按钮
        buttonDigiwinAthena.setIconData(59119);
        return buttonDigiwinAthena;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        super.handleComponentParam(cmptContext, mobilePath, schema, data, executeContext, mobilePageRawData);
        String value = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema))
                .map(Object::toString)
                .orElse(null);
        if (StringUtils.hasLength(value) && "PWD_RTP_InquiryReply".equals(executeContext.getTmActivityId())) {
            // 带图采购-询价回复-查看图纸-定制
            String onlineDrawingFormat = StringUtil.valueOf(UiBotDesignerRenderService.getDataByPathAndSchema(data, "inquiry_info.graph_info.online_drawing_format", "online_drawing_format"));
            if ("2".equals(onlineDrawingFormat)) {
                // 使用天喻插件 预览图纸
                value = AppContext.getApiUrlSetting().getMuiUrl() + "/graph-viewer?online_drawing_format=" + onlineDrawingFormat + "&cad_url=" + value;
            } else {
                try {
                    String[] parts = value.split("/");
                    String fileName = parts[parts.length - 1].split("\\.")[0];
                    // 转换DMC方式预览图纸
                    value = AppContext.getApiUrlSetting().getDmcUrl().replace("dmc-hw-test", "dmc-test") + "/api/dmc/v2/file/" + parts[parts.length - 4] + "/online/preview/" + fileName;
                } catch (Exception ignored) {
                }
            }
        }
        this.url = value;
        this.buttonList.add(createLeftSlipOpenWindowButton());
    }
}
