package com.digiwin.mobile.mobileuibot.core.component.webview;

import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：Webview面板组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: WebviewPanel
 * @Author: Zaregoto
 * @Date: 2021/9/7 21:39
 */
@Data
@AllArgsConstructor
public class WebviewPanel extends BaseMobileComponent {
    private static final long serialVersionUID = -8291802647768980615L;
    public static final String COMPONENT_TYPE = "WEBVIEW_PANEL";

    @Override
    public String returnComponentType() {
        return WebviewPanel.COMPONENT_TYPE;
    }

    private List<Webview> data;
    private String subtitle;
    private String title;

    public WebviewPanel() {
        this.data = new ArrayList<>();
    }

    public void addWebview(Webview webview) {
        if (null == this.data) {
            this.data = new ArrayList<>();
        } else {
            this.data.add(webview);
        }
    }

}

