package com.digiwin.mobile.mobileuibot.core.component.webview;

/**
 * <p>功能描述：Webview组件的尺寸模式枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: WebviewSizeModeEnum
 * @Author: Zaregoto
 * @Date: 2021/9/7 21:09
 */
public enum WebviewSizeModeEnum {
    /**
     * 小尺寸模式
     */
    SMALL(1),

    /**
     * 中尺寸模式
     */
    MEDIUM(2),

    /**
     * 大尺寸模式
     */
    LARGE(3),

    /**
     * 自定义模式，此时使用widthMode和aspectRatio定义webView大小
     */
    CUSTOMIZE(4),
    ;

    private final Integer mode;

    WebviewSizeModeEnum(Integer mode) {
        this.mode = mode;
    }

    public Integer getMode() {
        return mode;
    }
}
