package com.digiwin.mobile.mobileuibot.core.component.workflowprogress;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：流程进度组件</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: WorkflowProgress.java
 * @Author: wangjwc
 * @Date: created at 2024/1/5 10:03
 */
@Data
public class WorkflowProgress extends BaseMobileComponent {
    private static final long serialVersionUID = 6219674657172242764L;

    public static final String COMPONENT_TYPE = "WORKFLOW_PROGRESS";

    private static LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);
    /**
     * 组件标题
     */
    private String title;
    /**
     * 展示的字段值
     */
    private String displayValue;
    /**
     * 点击触发的事件
     * 当action不为空且action.type不为空时，value展示为可点击
     */
    private Action<Map<String, Object>> action;

    @Override
    public String returnComponentType() {
        return COMPONENT_TYPE;
    }

    @Override
    public void handleComponentParam(ComponentContext cmptContext, String mobilePath, String schema, Map<String, Object> data, PcUiBotExecuteContext executeContext, MobilePageRawData mobilePageRawData) {
        this.displayValue = localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "查看流程进度 >");
        String serialNumber = Optional.ofNullable(UiBotDesignerRenderService.getDataByPathAndSchema(data, mobilePath, schema))
                .map(Object::toString)
                .orElse(null);
        if (StringUtils.isEmpty(serialNumber)) {
            // serial_number为空，不显示流程进度
            this.displayValue = "";
            this.action = null;
            return;
        }
        this.action = buildAction(serialNumber);
    }

    private Action<Map<String, Object>> buildAction(String serialNumber) {
        Map<String, Object> rawData = new HashMap<>(2);
        rawData.put("workItemId", "");
        rawData.put("serialNumber", serialNumber);
        return buildAction(rawData);
    }

    public static Action<Map<String, Object>> buildAction(Map<String, Object> rawData) {
        Action<Map<String, Object>> action = new Action<>();
        action.setJumpPageTitle(localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "流程进度"));
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_WORKFLOW_PROGRESS_FIXATION_PAGE.toString());
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setRawData(rawData);
        return action;
    }
}
