package com.digiwin.mobile.mobileuibot.core.componentsetting;

/**
 * <p>功能描述：组件请求ID枚举类，用于标识特定组件的特定生成逻辑</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ComponentSettingRequestIdEnum
 * @Author: Zaregoto
 * @Date: 2021/10/18 22:05
 */
public enum ComponentSettingRequestIdEnum {
    /**
     * 首页-我的工作区-我的任务
     */
    INDEX_MY_WORKSPACE_TODO_LIST("INDEX-MY_WORKSPACE-TODO_LIST"),

    /**
     * 首页-我的工作区-项目进展
     */
    INDEX_MY_WORKSPACE_CARD_LIST("INDEX-MY_WORKSPACE-CARD_LIST"),

    /**
     * APP工作台-主管查看在线人员状态-按状态展示中-刷新整个tab数据
     */
    DIRECTOR_CHECK_PERSONNEL_STATE("DIRECTOR_CHECK-PERSONNEL_STATE"),

    /**
     * APP工作台-主管查看在线人员状态-按组别展示详情中-刷新整个tab
     */
    DIRECTOR_CHECK_PERSONNEL_GROUP_DETAIL("DIRECTOR_CHECK-PERSONNEL_GROUP_DETAIL"),
    /**
     * 在途宝车牌标识
     */
    OCR_ZTB_CAR_NUMBER("OCR_ZTB_CAR_NUMBER"),

    /**
     * 娜娜智能助理（B娜）——敏捷数据技能
     */
    AGILE_DATA_FOR_AI_ASSISTANT("AGILE_DATA_FOR_AI_ASSISTANT"),

    /**
     * 首页-我的工作区-三方待办列表
     */
    INDEX_MY_WORKSPACE_TRIPARTITE_TODO_LIST("INDEX-MY_WORKSPACE-TRIPARTITE_TODO_LIST"),

    ;

    private String reuqestId;

    ComponentSettingRequestIdEnum(String reuqestId) {
        this.reuqestId = reuqestId;
    }

    public String getReuqestId() {
        return reuqestId;
    }

    public void setReuqestId(String reuqestId) {
        this.reuqestId = reuqestId;
    }

    public static ComponentSettingRequestIdEnum getEnumByName(String name) {
        String tester = name;
        for (ComponentSettingRequestIdEnum requestIdEnum : ComponentSettingRequestIdEnum.values()) {
            if (requestIdEnum.getReuqestId().equalsIgnoreCase(tester)) {
                return requestIdEnum;
            }
        }
        return null;
    }
}
