package com.digiwin.mobile.mobileuibot.core.customtaskconfig;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklog;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：定制任务配置</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: CustomTaskConfig
 * @Author: Liux
 * @Date: 2022/04/13 17:00
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Document(collection = "customTaskConfig")
public class CustomTaskConfig implements Serializable {
    private static final long serialVersionUID = -7984118157325999337L;
    @Field("_id")
    private String id;

    //athena任务卡所属项目编码
    private String tmTaskId;
    //athena任务卡的任务编码
    private String tmActivityId;

    //定制任务URL配置类
    private CustomTaskUrlConfig customTaskUrlConfig;


    /**
     * 返回定制H5任务跳转用的最终详情url
     *
     * @param locale             语言别
     * @param iamUserToken
     * @param digiwinAtmcBacklog 任务卡数据
     * @return
     */
    public String getCustomTaskUrl(String locale, String iamUserToken, DigiwinAtmcBacklog digiwinAtmcBacklog) {
        Assert.notNull(this.getCustomTaskUrlConfig(), "CustomTaskUrlConfig MUST NOT NULL");
        CustomTaskUrlConfig customTaskUrlConfig = this.getCustomTaskUrlConfig();
        String requestUrl = customTaskUrlConfig.getScheme() + "://"
                + customTaskUrlConfig.getHost() + ":" + customTaskUrlConfig.getPort()
                + this.getQueryString(locale, iamUserToken, digiwinAtmcBacklog);

        return requestUrl;
    }


    /**
     * 返回定制H5任务详情url的查询参数
     *
     * @param locale             语言别
     * @param iamUserToken
     * @param digiwinAtmcBacklog 任务卡对象
     * @return
     */
    private String getQueryString(String locale, String iamUserToken, DigiwinAtmcBacklog digiwinAtmcBacklog) {
        Map<String, Object> queryMap = new LinkedHashMap<>();
        String tmTaskId = digiwinAtmcBacklog.getTmTaskId();
        String tmActivityId = digiwinAtmcBacklog.getTmActivityId();
        String tmPattern = digiwinAtmcBacklog.getTmPattern();
        String tmCategory = digiwinAtmcBacklog.getTmCategory();
        String backlogId = String.valueOf(digiwinAtmcBacklog.getBacklogId());
        String tenantId = digiwinAtmcBacklog.getTenantId();
        queryMap.put("locale", locale.trim());
        queryMap.put("mobile_user_token", iamUserToken.trim());
        queryMap.put("tmTaskId", tmTaskId.trim());
        queryMap.put("tmActivityId", tmActivityId.trim());
        queryMap.put("tmPattern", tmPattern.trim());
        queryMap.put("tmCategory", tmCategory.trim());
        queryMap.put("backlogId", backlogId.trim());
        queryMap.put("tenantId", tenantId.trim());
        if (StringUtils.hasLength(digiwinAtmcBacklog.getProxyToken())) {
            queryMap.put("digiProxyToken", digiwinAtmcBacklog.getProxyToken().trim());
        }

        String uriStr = Optional.of(this.getCustomTaskUrlConfig()).map(CustomTaskUrlConfig::getUri).orElse("");
        String queryString = uriStr;
        //判断是否为null,是为了避免为null是下面获取报异常
        if (null != queryMap) {
            /**
             * 先判断数据库中配置的uri地址是否包含了半角问号(?)
             *    如果没有的话直接拼接？加所有参数。
             *    如果有的话在判断里面哪些参数预写了，将没预写的参数加上去
             */
            if (uriStr.indexOf("?") < 0) {
                queryString = queryString + "?locale=" + queryMap.get("locale")         //移动端语言别,zh_CN,zh_TW,en_US
                        + "&mobile_user_token=" + queryMap.get("mobile_user_token")   //移动端登录时的token（来自IAM）
                        + "&tmTaskId=" + queryMap.get("tmTaskId")                     //athena任务卡所属项目编码
                        + "&tmActivityId=" + queryMap.get("tmActivityId")             //athena任务卡的任务编码
                        + "&tmPattern=" + queryMap.get("tmPattern")                   //athena任务卡的pattern编码
                        + "&tmCategory=" + queryMap.get("tmCategory")                 //athena任务卡的分类
                        + "&backlogId=" + queryMap.get("backlogId")                   //athena任务卡的id（具有唯一性）
                        + "&tenantId=" + queryMap.get("tenantId");                    //athena租户
                if (queryMap.containsKey("digiProxyToken")) {
                    queryString = queryString + "&digiProxyToken=" + queryMap.get("digiProxyToken");        //代理人token
                }
            } else {
                //遍历map，循环匹配参数
                for (Map.Entry entry : queryMap.entrySet()) {
                    //没匹配上返回值为-1,没匹配上说明没有这个参数，需要手动加上去.匹配上了需要替换掉占位符
                    if (uriStr.indexOf("${" + entry.getKey() + "}") < 0) {
                        queryString = queryString + "&" + entry.getKey() + "=" + entry.getValue();
                    } else {
                        queryString = queryString.replace("${" + entry.getKey() + "}", (String) entry.getValue());
                    }
                }

            }
        }
        return queryString;
    }
}
